/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute.completer;

import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.compute.ComputeService;
import org.jclouds.karaf.commands.cache.Cacheable;
import org.jclouds.karaf.utils.compute.ComputeHelper;

public abstract class ComputeCompleterSupport
implements Completer,
Cacheable<ComputeService> {
    private List<ComputeService> computeServices;
    protected final StringsCompleter delegate = new StringsCompleter();
    protected Set<String> cache;

    protected ComputeService getService() {
        ComputeService service = null;
        try {
            service = ComputeHelper.getComputeService(null, this.computeServices);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return service;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        this.delegate.getStrings().clear();
        for (String item : this.cache) {
            if (buffer != null && !item.startsWith(buffer)) continue;
            this.delegate.getStrings().add(item);
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    @Override
    public void updateCache() {
        this.cache.clear();
        for (ComputeService computeService : this.computeServices) {
            this.updateCache(computeService);
        }
    }

    public List<ComputeService> getComputeServices() {
        return this.computeServices;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }

    public Set<String> getCache() {
        return this.cache;
    }

    public void setCache(Set<String> cache) {
        this.cache = cache;
    }
}

