/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.util.LinkedList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandSupport;
import org.jclouds.karaf.commands.cache.CacheProvider;

@Command(scope="jclouds", name="blobstore-delete", description="Deletes a container")
public class BlobDeleteCommand
extends BlobStoreCommandSupport {
    @Argument(index=0, name="containerNames", description="The name of the container", required=true, multiValued=true)
    List<String> containerNames = new LinkedList<String>();
    @Option(name="-b", aliases={"--blob"}, multiValued=true)
    List<String> blobNames = new LinkedList<String>();

    protected Object doExecute() throws Exception {
        for (String container : this.containerNames) {
            if (!this.blobNames.isEmpty()) {
                for (String blobName : this.blobNames) {
                    if (!this.getBlobStore().blobExists(container, blobName)) continue;
                    this.getBlobStore().removeBlob(container, blobName);
                    CacheProvider.getCache("blob").remove(blobName);
                }
                continue;
            }
            this.getBlobStore().deleteContainer(container);
            CacheProvider.getCache("container").remove(container);
        }
        return null;
    }
}

