/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.base.Predicate;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

@Command(scope="jclouds", name="group-destroy")
public class GroupDestroyCommand
extends ComputeCommandSupport {
    @Argument(index=0, name="group", description="The group of nodes.", required=true, multiValued=false)
    private String group;

    protected Object doExecute() throws Exception {
        Set nodeMetadatas = this.getComputeService().destroyNodesMatching((Predicate)new Predicate<NodeMetadata>(){

            public boolean apply(@Nullable NodeMetadata input) {
                return input.getGroup().contains(GroupDestroyCommand.this.group);
            }
        });
        if (nodeMetadatas != null && !nodeMetadatas.isEmpty()) {
            System.out.println("Destroyed nodes:");
            this.printNodes(nodeMetadatas, "", System.out);
        }
        return null;
    }
}

