/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandSupport;
import org.jclouds.karaf.commands.cache.CacheProvider;

@Command(scope="jclouds", name="blobstore-list", description="Lists all containers")
public class BlobListCommand
extends BlobStoreCommandSupport {
    private static final String LISTFORMAT = "%-40s %-40s";

    protected Object doExecute() throws Exception {
        System.out.println(String.format(LISTFORMAT, "[Container]", "[Blob]"));
        for (StorageMetadata containerMetadata : this.getBlobStore().list()) {
            String containerName = containerMetadata.getName();
            CacheProvider.getCache("container").add(containerName);
            PageSet blobStoreMetadatas = this.getBlobStore().list(containerName, ListContainerOptions.Builder.recursive());
            if (blobStoreMetadatas == null || !blobStoreMetadatas.isEmpty()) {
                for (StorageMetadata blobMetadata : blobStoreMetadatas) {
                    String blobName = blobMetadata.getName();
                    CacheProvider.getCache("blob").add(blobName);
                    System.out.println(String.format(LISTFORMAT, containerName, blobName));
                    containerName = "";
                }
                System.out.println(String.format(LISTFORMAT, "", ""));
                continue;
            }
            System.out.println(String.format(LISTFORMAT, containerName, "<empty>"));
            System.out.println(String.format(LISTFORMAT, "", ""));
        }
        return null;
    }
}

