/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore.completer;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.karaf.commands.cache.Cacheable;
import org.jclouds.karaf.utils.blobstore.BlobStoreHelper;

public abstract class BlobStoreCompleterSupport
implements Completer,
Cacheable<BlobStore> {
    private List<BlobStore> blobStoreServices;
    protected final StringsCompleter delegate = new StringsCompleter();
    protected Set<String> cache;

    protected BlobStore getBlobStore() {
        BlobStore service = null;
        try {
            service = BlobStoreHelper.getBlobStore(null, this.blobStoreServices);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return service;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        this.delegate.getStrings().clear();
        for (String item : this.cache) {
            if (buffer != null && !item.startsWith(buffer)) continue;
            this.delegate.getStrings().add(item);
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    @Override
    public void updateCache() {
        this.cache.clear();
        for (BlobStore blobStore : this.getBlobStoreServices()) {
            this.updateCache(blobStore);
        }
    }

    protected Set<String> listContainers() {
        LinkedHashSet<String> containers = new LinkedHashSet<String>();
        for (BlobStore blobStore : this.blobStoreServices) {
            containers.addAll(this.listContainers(blobStore));
        }
        return containers;
    }

    protected Set<String> listContainers(BlobStore blobStore) {
        PageSet storageMetadatas;
        LinkedHashSet<String> containers = new LinkedHashSet<String>();
        if (blobStore != null && (storageMetadatas = blobStore.list()) != null && !storageMetadatas.isEmpty()) {
            for (StorageMetadata metadata : storageMetadatas) {
                containers.add(metadata.getName());
            }
        }
        return containers;
    }

    protected Set<String> listBlobs(String container) {
        LinkedHashSet<String> blobs = new LinkedHashSet<String>();
        for (BlobStore blobStore : this.blobStoreServices) {
            blobs.addAll(this.listBlobs(blobStore, container));
        }
        return blobs;
    }

    protected Set<String> listBlobs(BlobStore blobStore, String container) {
        PageSet storageMetadatas;
        LinkedHashSet<String> blobs = new LinkedHashSet<String>();
        if (blobStore != null && blobStore.containerExists(container) && (storageMetadatas = blobStore.list(container)) != null && !storageMetadatas.isEmpty()) {
            for (StorageMetadata metadata : storageMetadatas) {
                blobs.add(metadata.getName());
            }
        }
        return blobs;
    }

    public List<BlobStore> getBlobStoreServices() {
        return this.blobStoreServices;
    }

    public void setBlobStoreServices(List<BlobStore> blobStoreServices) {
        this.blobStoreServices = blobStoreServices;
    }

    public Set<String> getCache() {
        return this.cache;
    }

    public void setCache(Set<String> cache) {
        this.cache = cache;
    }
}

