/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

@Command(scope="jclouds", name="node-create")
public class NodeCreateCommand
extends ComputeCommandSupport {
    @Option(name="--smallest")
    private boolean smallest;
    @Option(name="--fastest")
    private boolean fastest;
    @Option(name="--biggest")
    private boolean biggest;
    @Option(name="--hardwareId")
    private String hardwareId;
    @Option(name="--ec2-security-groups", multiValued=true)
    private List<String> ec2SecurityGroups;
    @Option(name="--ec2-key-pair")
    private String ec2KeyPair;
    @Option(name="--ec2-no-key-pair")
    private String ec2NoKeyPair;
    @Argument(name="imageId", index=0, multiValued=false, required=true, description="Image")
    private String imageId;
    @Argument(name="locationId", index=1, multiValued=false, required=true, description="Location")
    private String locationId;
    @Argument(name="group", index=2, multiValued=false, required=true, description="Node group")
    private String group;
    @Argument(name="number", index=3, multiValued=false, required=false, description="Number of nodes to create")
    private Integer number = 1;

    protected Object doExecute() throws Exception {
        ComputeService service = this.getComputeService();
        TemplateBuilder builder = service.templateBuilder();
        builder.any();
        if (this.smallest) {
            builder.smallest();
        }
        if (this.fastest) {
            builder.fastest();
        }
        if (this.biggest) {
            builder.biggest();
        }
        if (this.locationId != null) {
            builder.locationId(this.locationId);
        }
        if (this.imageId != null) {
            builder.imageId(this.imageId);
        }
        if (this.hardwareId != null) {
            builder.hardwareId(this.hardwareId);
        }
        if (this.ec2SecurityGroups != null) {
            ((EC2TemplateOptions)builder.build().getOptions().as(EC2TemplateOptions.class)).securityGroups(this.ec2SecurityGroups);
        }
        if (this.ec2KeyPair != null) {
            ((EC2TemplateOptions)builder.build().getOptions().as(EC2TemplateOptions.class)).keyPair(this.ec2KeyPair);
        }
        if (this.ec2NoKeyPair != null) {
            ((EC2TemplateOptions)builder.build().getOptions().as(EC2TemplateOptions.class)).noKeyPair();
        }
        Set metadatas = null;
        try {
            metadatas = service.createNodesInGroup(this.group, this.number.intValue(), builder.build());
        }
        catch (RunNodesException ex) {
            System.out.println("Failed to create nodes:" + ex.getMessage());
        }
        if (metadatas != null && !metadatas.isEmpty()) {
            System.out.println("Created nodes:");
            this.printNodes(metadatas, "", System.out);
        }
        return null;
    }
}

