/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.karaf.cache.BasicCacheProvider;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobStoreCommandBase
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreCommandBase.class);
    public static final String PROVIDERFORMAT = "%-24s %-12s %-12s";
    protected List<BlobStore> services = new ArrayList<BlobStore>();
    protected CacheProvider cacheProvider = new BasicCacheProvider();

    public Object execute(CommandSession session) throws Exception {
        try {
            this.session = session;
            return this.doExecute();
        }
        catch (AuthorizationException ex) {
            System.err.println("Authorization error. Please make sure you provided valid identity and credential.");
            return null;
        }
    }

    public void setBlobStoreServices(List<BlobStore> services) {
        this.services = services;
    }

    protected List<BlobStore> getBlobStoreServices() {
        return this.services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(BlobStore blobStore, String containerName, String blobName) {
        Object result = null;
        ObjectInputStream ois = null;
        blobStore.createContainerInLocation(null, containerName);
        InputStream is = blobStore.getBlob(containerName, blobName).getPayload().getInput();
        try {
            ois = new ObjectInputStream(is);
            result = ois.readObject();
        }
        catch (IOException e) {
            LOGGER.error("Error reading object.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error reading object.", (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public InputStream getBlobInputStream(BlobStore blobStore, String containerName, String blobName) throws Exception {
        if (blobStore.blobExists(containerName, blobName)) {
            return blobStore.getBlob(containerName, blobName).getPayload().getInput();
        }
        throw new Exception("Blob " + blobName + " does not exist in conatiner " + containerName + ".");
    }

    public void write(BlobStore blobStore, String containerName, String blobName, Object object) {
        Blob blob = blobStore.blobBuilder(blobName).build();
        blob.setPayload(this.toBytes(object));
        blobStore.putBlob(containerName, blob);
    }

    public void write(BlobStore blobStore, String bucket, String blobName, InputStream is) {
        try {
            String directory;
            if (blobName.contains("/") && !Strings.isNullOrEmpty((String)(directory = BlobStoreUtils.parseDirectoryFromPath((String)blobName)))) {
                blobStore.createDirectory(bucket, directory);
            }
            Blob blob = blobStore.blobBuilder(blobName).payload(ByteStreams.toByteArray((InputStream)is)).build();
            blobStore.putBlob(bucket, blob);
            is.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Error closing input stream.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object object) {
        byte[] result = null;
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            result = baos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Error while writing blob", (Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromUrl(URL url) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(url.openStream());
            int size = 0;
            while ((size = dis.available()) > 0) {
                byte[] buffer = new byte[size];
                baos.write(buffer);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read from stream.", (Throwable)e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
        }
        return new byte[0];
    }

    protected void printBlobStoreProviders(Map<String, ProviderMetadata> providers, List<BlobStore> blobStores, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (String provider : providers.keySet()) {
            boolean registered = false;
            for (BlobStore blobStore : blobStores) {
                if (!blobStore.getContext().unwrap().getId().equals(provider)) continue;
                registered = true;
                break;
            }
            out.println(String.format(PROVIDERFORMAT, provider, "blobstore", registered));
        }
    }

    protected void printBlobStoreApis(Map<String, ApiMetadata> apis, List<BlobStore> blobStores, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (String provider : apis.keySet()) {
            boolean registered = false;
            for (BlobStore blobStore : blobStores) {
                if (!blobStore.getContext().unwrap().getId().equals(provider)) continue;
                registered = true;
                break;
            }
            out.println(String.format(PROVIDERFORMAT, provider, "blobstore", registered));
        }
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

