/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import org.apache.felix.gogo.commands.Command;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandBase;
import org.jclouds.karaf.core.BlobStoreProviderOrApiRegistry;

@Command(scope="jclouds", name="blobstore-service-list", description="List available BlobStore services.", detailedDescription="classpath:blobstore-service-list.txt")
public class BlobStoreListCommand
extends BlobStoreCommandBase {
    private BlobStoreProviderOrApiRegistry blobStoreProviderOrApiRegistry;

    protected Object doExecute() throws Exception {
        try {
            if (this.blobStoreProviderOrApiRegistry.getInstalledApis() != null && !this.blobStoreProviderOrApiRegistry.getInstalledApis().isEmpty()) {
                System.out.println("BlobStore APIs:");
                System.out.println("---------------");
                this.printBlobStoreApis(this.blobStoreProviderOrApiRegistry.getInstalledApis(), this.getBlobStoreServices(), "", System.out);
            } else {
                System.out.println("No blob store APIs found.");
            }
            System.out.println();
            System.out.println();
            System.out.println("BlobStore Providers:");
            System.out.println("--------------------");
            if (this.blobStoreProviderOrApiRegistry.getInstalledProviders() != null && !this.blobStoreProviderOrApiRegistry.getInstalledProviders().isEmpty()) {
                this.printBlobStoreProviders(this.blobStoreProviderOrApiRegistry.getInstalledProviders(), this.getBlobStoreServices(), "", System.out);
            } else {
                System.out.println("No blob store providers found.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public BlobStoreProviderOrApiRegistry getBlobStoreProviderOrApiRegistry() {
        return this.blobStoreProviderOrApiRegistry;
    }

    public void setBlobStoreProviderOrApiRegistry(BlobStoreProviderOrApiRegistry blobStoreProviderOrApiRegistry) {
        this.blobStoreProviderOrApiRegistry = blobStoreProviderOrApiRegistry;
    }
}

