/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.io.IOException;
import java.util.Dictionary;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class BlobStoreServiceCommand
extends BlobStoreCommandWithOptions {
    protected static final String FACTORY_FILTER = "(service.factoryPid=%s)";
    protected ConfigurationAdmin configAdmin;

    protected Configuration findOrCreateFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, String provider, String api) throws IOException {
        Configuration configuration = null;
        if (configurationAdmin != null) {
            try {
                Configuration[] configurations = configurationAdmin.listConfigurations(String.format(FACTORY_FILTER, factoryPid));
                if (configurations != null) {
                    for (Configuration conf : configurations) {
                        Dictionary dictionary = conf.getProperties();
                        if (dictionary != null && provider != null && provider.equals(dictionary.get("provider"))) {
                            return conf;
                        }
                        if (dictionary == null || api == null || !api.equals(dictionary.get("api"))) continue;
                        return conf;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            configuration = configurationAdmin.createFactoryConfiguration(factoryPid, null);
        }
        return configuration;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

