/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore.completer;

import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.providers.Providers;

public class BlobStoreProviderCompleter
implements Completer {
    private final StringsCompleter delegate = new StringsCompleter();
    private List<? extends BlobStore> blobStoreServices;

    public int complete(String buffer, int cursor, List<String> candidates) {
        try {
            if (this.blobStoreServices != null) {
                for (BlobStore blobStore : this.blobStoreServices) {
                    String id = blobStore.getContext().unwrap().getId();
                    if (Providers.withId((String)id) == null) continue;
                    this.delegate.getStrings().add(id);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    public List<? extends BlobStore> getBlobStoreServices() {
        return this.blobStoreServices;
    }

    public void setBlobStoreServices(List<? extends BlobStore> blobStoreServices) {
        this.blobStoreServices = blobStoreServices;
    }
}

