/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute.completer;

import com.google.common.collect.Multimap;
import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.compute.ComputeService;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.cache.Cacheable;

public abstract class ComputeCompleterSupport
implements Completer,
Cacheable<ComputeService> {
    protected final StringsCompleter delegate = new StringsCompleter();
    protected CacheProvider cacheProvider;
    protected Multimap<String, String> cache;

    public int complete(String buffer, int cursor, List<String> candidates) {
        this.delegate.getStrings().clear();
        for (String item : this.cache.values()) {
            if (buffer != null && !item.startsWith(buffer)) continue;
            this.delegate.getStrings().add(item);
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    public void updateOnRemoved(ComputeService computeService) {
        this.cache.removeAll((Object)computeService.getContext().unwrap().getId());
    }

    public Multimap<String, String> getCache() {
        return this.cache;
    }

    public void setCache(Multimap<String, String> cache) {
        this.cache = cache;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

