/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.util.LinkedList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandSupport;

@Command(scope="jclouds", name="blobstore-delete", description="Deletes a container")
public class BlobDeleteCommand
extends BlobStoreCommandSupport {
    @Argument(index=0, name="containerNames", description="The name of the container", required=true, multiValued=true)
    List<String> containerNames = new LinkedList<String>();
    @Option(name="-b", aliases={"--blob"}, multiValued=true)
    List<String> blobNames = new LinkedList<String>();

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        if (blobStore == null) {
            System.out.println("Failed to find or create a blob store.");
            return null;
        }
        for (String container : this.containerNames) {
            if (!this.blobNames.isEmpty()) {
                for (String blobName : this.blobNames) {
                    if (!this.getBlobStore().blobExists(container, blobName)) continue;
                    this.getBlobStore().removeBlob(container, blobName);
                    this.cacheProvider.getProviderCacheForType("blob").remove((Object)blobStore.getContext().getProviderSpecificContext().getId(), (Object)blobName);
                }
                continue;
            }
            this.getBlobStore().deleteContainer(container);
            this.cacheProvider.getProviderCacheForType("container").remove((Object)blobStore.getContext().getProviderSpecificContext().getId(), (Object)container);
        }
        return null;
    }
}

