/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandSupport;

@Command(scope="jclouds", name="blobstore-list", description="Lists all containers")
public class BlobListCommand
extends BlobStoreCommandSupport {
    private static final String LISTFORMAT = "%-40s %-40s";

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        if (blobStore == null) {
            System.out.println("Failed to find or create a blob store.");
            return null;
        }
        System.out.println(String.format(LISTFORMAT, "[Container]", "[Blob]"));
        for (StorageMetadata containerMetadata : blobStore.list()) {
            String containerName = containerMetadata.getName();
            this.cacheProvider.getProviderCacheForType("container").put((Object)containerMetadata.getProviderId(), (Object)containerName);
            PageSet blobStoreMetadatas = blobStore.list(containerName, ListContainerOptions.Builder.recursive());
            if (blobStoreMetadatas == null || !blobStoreMetadatas.isEmpty()) {
                for (StorageMetadata blobMetadata : blobStoreMetadatas) {
                    String blobName = blobMetadata.getName();
                    this.cacheProvider.getProviderCacheForType("blob").put((Object)containerMetadata.getProviderId(), (Object)blobName);
                    System.out.println(String.format(LISTFORMAT, containerName, blobName));
                    containerName = "";
                }
                System.out.println(String.format(LISTFORMAT, "", ""));
                continue;
            }
            System.out.println(String.format(LISTFORMAT, containerName, "<empty>"));
            System.out.println(String.format(LISTFORMAT, "", ""));
        }
        return null;
    }
}

