/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandSupport;

@Command(scope="jclouds", name="blobstore-read", description="Reads data from the blobstore")
public class BlobReadCommand
extends BlobStoreCommandSupport {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=false)
    String containerName;
    @Argument(index=1, name="blobName", description="The name of the blob", required=true, multiValued=false)
    String blobName;
    @Option(name="-f", aliases={"--to-file"}, description="The file to store the blob", required=false, multiValued=false)
    String file;
    @Option(name="-d", aliases={"--display"}, description="Display the content to the console", required=false, multiValued=false)
    Boolean display;

    protected Object doExecute() throws Exception {
        File f;
        BlobStore blobStore = this.getBlobStore();
        if (blobStore == null) {
            System.out.println("Failed to find or create a blob store.");
            return null;
        }
        if (!Strings.isNullOrEmpty((String)this.file) && !(f = new File(this.file)).exists() && f.createNewFile()) {
            ByteStreams.copy((InputStream)this.getBlobInputStream(blobStore, this.containerName, this.blobName), (OutputStream)new FileOutputStream(f));
        }
        if (this.display.booleanValue()) {
            InputStream inputStream = this.getBlobInputStream(blobStore, this.containerName, this.blobName);
            System.err.println(new String(ByteStreams.toByteArray((InputStream)inputStream)));
        }
        return null;
    }
}

