/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore.completer;

import com.google.common.collect.Multimap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.cache.Cacheable;

public abstract class BlobStoreCompleterSupport
implements Completer,
Cacheable<BlobStore> {
    protected final StringsCompleter delegate = new StringsCompleter();
    protected Multimap<String, String> cache;
    protected CacheProvider cacheProvider;

    public int complete(String buffer, int cursor, List<String> candidates) {
        this.delegate.getStrings().clear();
        for (String item : this.cache.values()) {
            if (buffer != null && !item.startsWith(buffer)) continue;
            this.delegate.getStrings().add(item);
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    protected Set<String> listContainers(BlobStore blobStore) {
        PageSet storageMetadatas;
        LinkedHashSet<String> containers = new LinkedHashSet<String>();
        if (blobStore != null && (storageMetadatas = blobStore.list()) != null && !storageMetadatas.isEmpty()) {
            for (StorageMetadata metadata : storageMetadatas) {
                containers.add(metadata.getName());
            }
        }
        return containers;
    }

    protected Set<String> listBlobs(BlobStore blobStore, String container) {
        PageSet storageMetadatas;
        LinkedHashSet<String> blobs = new LinkedHashSet<String>();
        if (blobStore != null && blobStore.containerExists(container) && (storageMetadatas = blobStore.list(container)) != null && !storageMetadatas.isEmpty()) {
            for (StorageMetadata metadata : storageMetadatas) {
                blobs.add(metadata.getName());
            }
        }
        return blobs;
    }

    public void updateOnRemoved(BlobStore blobStore) {
        this.cache.removeAll((Object)blobStore.getContext().getProviderSpecificContext().getId());
    }

    public Multimap<String, String> getCache() {
        return this.cache;
    }

    public void setCache(Multimap<String, String> cache) {
        this.cache = cache;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

