/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

@Command(scope="jclouds", name="image-create", description="Create an image from an existing node.")
public class ImageCreateCommand
extends ComputeCommandSupport {
    @Argument(name="id", index=0, description="The id of the node to use as a template.", required=true, multiValued=false)
    private String id;
    @Argument(name="name", index=1, description="The name of the image template.", required=true, multiValued=false)
    private String name;

    protected Object doExecute() throws Exception {
        ComputeService service = this.getComputeService();
        if (service == null) {
            System.out.println("Failed to find or create a compute service.");
            return null;
        }
        if (!service.getImageExtension().isPresent()) {
            System.out.print("Provider " + this.getComputeService().getContext().unwrap().getProviderMetadata().getId() + " does not currently provide image creation support.");
            return null;
        }
        ImageExtension imageExtension = (ImageExtension)service.getImageExtension().get();
        ImageTemplate imageTemplate = imageExtension.buildImageTemplateFromNode(this.name, this.id);
        ListenableFuture imageFuture = imageExtension.createImage(imageTemplate);
        Image image = (Image)imageFuture.get();
        System.out.println("Succesfully created image:" + image.getId());
        return null;
    }
}

