/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import org.apache.felix.gogo.commands.Command;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

@Command(scope="jclouds", name="node-list", description="Displays the list of nodes.")
public class NodeListCommand
extends ComputeCommandSupport {
    protected Object doExecute() throws Exception {
        ComputeService service = this.getComputeService();
        if (service == null) {
            System.out.println("Failed to find or create a compute service.");
            return null;
        }
        this.printNodes(service.listNodes(), "", System.out);
        for (ComputeMetadata node : service.listNodes()) {
            if (!(node instanceof NodeMetadata)) continue;
            NodeMetadata metadata = (NodeMetadata)node;
            if (metadata.getState().equals((Object)NodeState.RUNNING)) {
                this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").put((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").remove((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").remove((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                continue;
            }
            if (metadata.getState().equals((Object)NodeState.SUSPENDED)) {
                this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").put((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").put((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                continue;
            }
            if (metadata.getState().equals((Object)NodeState.TERMINATED)) {
                this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").remove((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").remove((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
                continue;
            }
            this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().getProviderSpecificContext().getId(), (Object)node.getId());
        }
        return null;
    }
}

