/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.base.Predicate;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

public abstract class NodeRunScriptSupport
extends ComputeCommandSupport {
    @Option(name="-u", aliases={"--user"}, description="The user that will run the script.", required=false, multiValued=false)
    private String user;
    @Option(name="-s", aliases={"--script-url"}, description="The url script of the script to run.", required=false, multiValued=false)
    private String scriptUrl;
    @Option(name="-d", aliases={"--direct"}, description="A direct command passed to the node to run. ", required=false, multiValued=false)
    private String directCommand;

    public abstract String getId();

    public abstract String getGroup();

    protected Object doExecute() throws Exception {
        ComputeService service = this.getComputeService();
        if (service == null) {
            System.out.println("Failed to find or create a compute service.");
            return null;
        }
        Set nodeMetaDataSet = service.listNodesDetailsMatching(this.getComputeFilter());
        if (nodeMetaDataSet != null && !nodeMetaDataSet.isEmpty()) {
            NodeMetadata nodeMetadata = nodeMetaDataSet.toArray(new NodeMetadata[0])[0];
            this.printNodeInfo(nodeMetaDataSet, nodeMetaDataSet.size() == 1, System.out);
            LoginCredentials credentials = nodeMetadata.getCredentials();
            if (this.user != null) {
                credentials = credentials.toBuilder().user(this.user).build();
            }
            Map responseMap = service.runScriptOnNodesMatching(this.getNodeFilter(), this.getScript(), RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(false));
            for (Map.Entry entry : responseMap.entrySet()) {
                ExecResponse response = (ExecResponse)entry.getValue();
                NodeMetadata node = (NodeMetadata)entry.getKey();
                System.out.println("");
                if (response.getOutput() != null && !response.getOutput().isEmpty()) {
                    System.out.println("Node:" + node.getId() + " Output:" + response.getOutput());
                }
                if (response.getError() == null || response.getError().isEmpty()) continue;
                System.out.println("Node:" + node.getId() + " Error:" + response.getError());
            }
        }
        return null;
    }

    public Predicate<NodeMetadata> getNodeFilter() {
        return new Predicate<NodeMetadata>(){

            public boolean apply(@Nullable NodeMetadata input) {
                boolean applies = true;
                if (!input.getState().equals((Object)NodeState.RUNNING)) {
                    return false;
                }
                if (NodeRunScriptSupport.this.getId() != null && !NodeRunScriptSupport.this.getId().isEmpty() && !input.getId().equals(NodeRunScriptSupport.this.getId())) {
                    applies = false;
                }
                if (NodeRunScriptSupport.this.getGroup() != null && !NodeRunScriptSupport.this.getGroup().isEmpty() && !input.getGroup().equals(NodeRunScriptSupport.this.getGroup())) {
                    applies = false;
                }
                return applies;
            }
        };
    }

    public Predicate<ComputeMetadata> getComputeFilter() {
        return new Predicate<ComputeMetadata>(){

            public boolean apply(@Nullable ComputeMetadata input) {
                boolean applies = true;
                if (input instanceof NodeMetadata) {
                    if (!((NodeMetadata)input).getState().equals((Object)NodeState.RUNNING)) {
                        return false;
                    }
                    if (NodeRunScriptSupport.this.getId() != null && !NodeRunScriptSupport.this.getId().isEmpty() && !input.getId().equals(NodeRunScriptSupport.this.getId())) {
                        applies = false;
                    }
                    if (NodeRunScriptSupport.this.getGroup() != null && !NodeRunScriptSupport.this.getGroup().isEmpty() && !((NodeMetadata)input).getGroup().equals(NodeRunScriptSupport.this.getGroup())) {
                        applies = false;
                    }
                }
                return applies;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getScript() {
        if (this.directCommand != null) {
            return this.directCommand;
        }
        if (this.scriptUrl != null) {
            InputStream is = null;
            FilterInputStream in = null;
            BufferedReader br = null;
            StringBuilder builder = new StringBuilder();
            try {
                URL url = new URL(this.scriptUrl);
                is = url.openStream();
                in = new DataInputStream(is);
                br = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while ((line = br.readLine()) != null) {
                    builder.append(line).append("\n");
                }
                String string = builder.toString();
                return string;
            }
            catch (MalformedURLException e) {
                System.err.println("The provided script url is invalid.");
            }
            catch (IOException e) {
                System.err.println("Cannot read script from url.");
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception ex) {}
                try {
                    in.close();
                }
                catch (Exception ex) {}
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return "";
    }
}

