/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.Processor;
import org.jclouds.domain.Location;
import org.jclouds.karaf.cache.BasicCacheProvider;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.utils.EnvHelper;
import org.jclouds.karaf.utils.compute.ComputeHelper;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class ComputeCommandSupport
extends AbstractAction {
    public static final String NODEFORMAT = "%s%-30s %-32s %-20s %-12s %-12s";
    private static final String NODE_DETAILS_FORMAT = "%20s %-60s";
    public static final String HARDWAREFORMAT = "%s%-20s %5s %7s %6s";
    public static final String IMAGEFORMAT = "%s%-30s %-32s %s";
    public static final String LOCATIONFORMAT = "%-32s %-9s %s";
    public static final String PROVIDERFORMAT = "%-24s %-12s %-12s";
    private ConfigurationAdmin configurationAdmin;
    private List<ComputeService> computeServices = new ArrayList<ComputeService>();
    protected CacheProvider cacheProvider = new BasicCacheProvider();
    @Option(name="--provider", description="The provider or use.")
    protected String provider;
    @Option(name="--api", description="The api or use.")
    protected String api;
    @Option(name="--identity", description="The identity to use for creating a compute service.")
    protected String identity;
    @Option(name="--credential", description="The credential to use for a compute service.")
    protected String credential;
    @Option(name="--endpoint", description="The endpoint to use for a compute service.")
    protected String endpoint;

    protected void printComputeProviders(Map<String, ProviderMetadata> providers, List<ComputeService> computeServices, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (String provider : providers.keySet()) {
            boolean registered = false;
            for (ComputeService computeService : computeServices) {
                if (!computeService.getContext().unwrap().getId().equals(provider)) continue;
                registered = true;
                break;
            }
            out.println(String.format(PROVIDERFORMAT, provider, "compute", registered));
        }
    }

    protected void printComputeApis(Map<String, ApiMetadata> apis, List<ComputeService> computeServices, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (String api : apis.keySet()) {
            boolean registered = false;
            for (ComputeService computeService : computeServices) {
                if (!computeService.getContext().unwrap().getId().equals(api)) continue;
                registered = true;
                break;
            }
            out.println(String.format(PROVIDERFORMAT, api, "compute", registered));
        }
    }

    protected void printNodes(Set<? extends ComputeMetadata> nodes, String indent, PrintStream out) {
        out.println(String.format(NODEFORMAT, indent, "[id]", "[location]", "[hardware]", "[group]", "[state]"));
        for (ComputeMetadata computeMetadata : nodes) {
            NodeMetadata node = (NodeMetadata)computeMetadata;
            out.println(String.format(NODEFORMAT, indent, node.getId(), node.getLocation().getId(), node.getHardware().getId(), node.getGroup(), node.getState().toString().toLowerCase()));
            this.cacheProvider.getProviderCacheForType("GROUP").put((Object)node.getProviderId(), (Object)node.getGroup());
        }
    }

    protected void printHardwares(Set<? extends Hardware> hardwares, String indent, PrintStream out) {
        out.println(String.format(HARDWAREFORMAT, indent, "[id]", "[cpu]", "[cores]", "[ram]", "[disk]"));
        for (Hardware hardware : hardwares) {
            out.println(String.format(HARDWAREFORMAT, indent, hardware.getId(), this.getCpuUnits(hardware), this.getCpuCores(hardware), this.getMemory(hardware)));
            this.cacheProvider.getProviderCacheForType("HARDWARE_CACHE").put((Object)hardware.getProviderId(), (Object)hardware.getId());
        }
    }

    protected void printImages(Set<? extends Image> images, String indent, PrintStream out) {
        out.println(String.format(IMAGEFORMAT, indent, "[id]", "[location]", "[description]"));
        for (Image image : images) {
            String id = image.getId();
            String location = image.getLocation() != null ? image.getLocation().getId() : "";
            String description = image.getDescription();
            out.println(String.format(IMAGEFORMAT, indent, id, location, description));
            this.cacheProvider.getProviderCacheForType("IMAGE_CACHE").put((Object)image.getProviderId(), (Object)image.getId());
        }
    }

    protected void printLocations(ComputeService computeService, String indent, PrintStream out) {
        out.println(String.format(LOCATIONFORMAT, indent + "[id]", "[scope]", "[description]"));
        this.printLocations(this.getAllLocations(computeService), null, indent, out);
    }

    protected void printLocations(Set<? extends Location> locations, Location parent, String indent, PrintStream out) {
        for (Location location : locations) {
            if (location.getParent() != parent) continue;
            out.println(String.format(LOCATIONFORMAT, indent + location.getId(), location.getScope(), location.getDescription()));
            this.printLocations(locations, location, indent + "  ", out);
        }
    }

    protected Set<? extends Location> getAllLocations(ComputeService computeService) {
        HashSet<Location> all = new HashSet<Location>();
        Iterator i$ = computeService.listAssignableLocations().iterator();
        while (i$.hasNext()) {
            Location loc;
            for (Location p = loc = (Location)i$.next(); p != null; p = p.getParent()) {
                all.add(p);
                this.cacheProvider.getProviderCacheForType("LOCATION_CACHE").put((Object)computeService.getContext().unwrap().getId(), (Object)p.getId());
            }
        }
        return all;
    }

    protected String getOperatingSystemDetails(NodeMetadata node) {
        OperatingSystem os;
        if (node != null && (os = node.getOperatingSystem()) != null) {
            return node.getOperatingSystem().getFamily().value() + " " + node.getOperatingSystem().getArch() + " " + node.getOperatingSystem().getVersion();
        }
        return "";
    }

    protected String getPublicAddresses(NodeMetadata node) {
        StringBuilder sb = new StringBuilder();
        if (node != null && node.getPublicAddresses() != null && !node.getPublicAddresses().isEmpty()) {
            Set publicAddresses = node.getPublicAddresses();
            Iterator addressIterator = publicAddresses.iterator();
            while (addressIterator.hasNext()) {
                sb.append((String)addressIterator.next());
                if (!addressIterator.hasNext()) continue;
                sb.append(" , ");
            }
        }
        return sb.toString();
    }

    protected String getPrivateAddresses(NodeMetadata node) {
        StringBuilder sb = new StringBuilder();
        if (node != null && node.getPrivateAddresses() != null && !node.getPrivateAddresses().isEmpty()) {
            Set privateAddresses = node.getPrivateAddresses();
            Iterator addressIterator = privateAddresses.iterator();
            while (addressIterator.hasNext()) {
                sb.append((String)addressIterator.next());
                if (!addressIterator.hasNext()) continue;
                sb.append(" , ");
            }
        }
        return sb.toString();
    }

    protected void printNodeInfo(Set<? extends NodeMetadata> nodes, boolean details, PrintStream out) {
        this.printNodes(nodes, "", out);
        if (details) {
            for (NodeMetadata nodeMetadata : nodes) {
                out.println();
                out.println(String.format(NODE_DETAILS_FORMAT, "Operating System:", this.getOperatingSystemDetails(nodeMetadata)));
                out.println(String.format(NODE_DETAILS_FORMAT, "Configured User:", nodeMetadata.getCredentials().getUser()));
                out.println(String.format(NODE_DETAILS_FORMAT, "Public Address:", this.getPublicAddresses(nodeMetadata)));
                out.println(String.format(NODE_DETAILS_FORMAT, "Private Address:", this.getPrivateAddresses(nodeMetadata)));
                out.println(String.format(NODE_DETAILS_FORMAT, "Image Id:", nodeMetadata.getImageId()));
            }
        }
    }

    protected double getMemory(Hardware hardware) {
        return hardware.getRam();
    }

    protected double getCpuCores(Hardware hardware) {
        int nb = 0;
        for (Processor p : hardware.getProcessors()) {
            nb = (int)((double)nb + p.getCores());
        }
        return nb;
    }

    protected double getCpuUnits(Hardware hardware) {
        double nb = 0.0;
        for (Processor p : hardware.getProcessors()) {
            nb += p.getCores() * p.getSpeed();
        }
        return nb;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }

    protected List<ComputeService> getComputeServices() {
        if (this.provider == null && this.api == null) {
            return this.computeServices;
        }
        return Collections.singletonList(this.getComputeService());
    }

    protected ComputeService getComputeService() {
        String providerOrApiValue;
        boolean canCreateService;
        String endpointValue;
        String credentialValue;
        String identityValue;
        ComputeService computeService;
        block5: {
            if (this.computeServices != null && this.computeServices.size() == 1) {
                return this.computeServices.get(0);
            }
            computeService = null;
            String providerValue = EnvHelper.getComputeProvider(this.provider);
            String apiValue = EnvHelper.getComputeApi(this.api);
            identityValue = EnvHelper.getComputeIdentity(this.identity);
            credentialValue = EnvHelper.getComputeCredential(this.credential);
            endpointValue = EnvHelper.getComputeEndpoint(this.endpoint);
            canCreateService = (!Strings.isNullOrEmpty((String)providerValue) || !Strings.isNullOrEmpty((String)apiValue)) && !Strings.isNullOrEmpty((String)identityValue) && !Strings.isNullOrEmpty((String)credentialValue);
            providerOrApiValue = !Strings.isNullOrEmpty((String)providerValue) ? providerValue : apiValue;
            try {
                computeService = ComputeHelper.getComputeService(providerOrApiValue, this.computeServices);
            }
            catch (Throwable t) {
                if (canCreateService) break block5;
                throw new RuntimeException(t.getMessage());
            }
        }
        if (computeService == null && canCreateService) {
            ContextBuilder builder = ContextBuilder.newBuilder((String)providerOrApiValue).credentials(identityValue, credentialValue).modules((Iterable)ImmutableSet.of((Object)new SshjSshClientModule()));
            if (!Strings.isNullOrEmpty((String)endpointValue)) {
                builder = builder.endpoint(endpointValue);
            }
            computeService = ((ComputeServiceContext)builder.build(ComputeServiceContext.class)).getComputeService();
        }
        return computeService;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

