/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import org.apache.felix.gogo.commands.Command;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;
import org.jclouds.karaf.core.ComputeProviderOrApiRegistry;

@Command(scope="jclouds", name="compute-service-list", description="Lists the Compute APIs and Providers")
public class ComputeListCommand
extends ComputeCommandSupport {
    private ComputeProviderOrApiRegistry computeProviderOrApiRegistry;

    protected Object doExecute() throws Exception {
        try {
            if (this.computeProviderOrApiRegistry.getInstalledApis() != null && !this.computeProviderOrApiRegistry.getInstalledApis().isEmpty()) {
                System.out.println("Compute APIs:");
                System.out.println("-------------");
                this.printComputeApis(this.computeProviderOrApiRegistry.getInstalledApis(), this.getComputeServices(), "", System.out);
            } else {
                System.out.println("No compute APIs found.");
            }
            System.out.println();
            System.out.println();
            System.out.println("Compute Providers:");
            System.out.println("------------------");
            if (this.computeProviderOrApiRegistry.getInstalledProviders() != null && !this.computeProviderOrApiRegistry.getInstalledProviders().isEmpty()) {
                this.printComputeProviders(this.computeProviderOrApiRegistry.getInstalledProviders(), this.getComputeServices(), "", System.out);
            } else {
                System.out.println("No compute providers found.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ComputeProviderOrApiRegistry getComputeProviderOrApiRegistry() {
        return this.computeProviderOrApiRegistry;
    }

    public void setComputeProviderOrApiRegistry(ComputeProviderOrApiRegistry computeProviderOrApiRegistry) {
        this.computeProviderOrApiRegistry = computeProviderOrApiRegistry;
    }
}

