/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

@Command(scope="jclouds", name="node-list", description="Displays the list of nodes.")
public class NodeListCommand
extends ComputeCommandSupport {
    @Option(name="-g", aliases={"--group"}, multiValued=false, required=false, description="Node group")
    private String group;

    protected Object doExecute() throws Exception {
        ComputeService service = null;
        try {
            service = this.getComputeService();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
        Set nodes = service.listNodesDetailsMatching((Predicate)new Predicate<ComputeMetadata>(){

            public boolean apply(@Nullable ComputeMetadata input) {
                NodeMetadata node = (NodeMetadata)input;
                return Strings.isNullOrEmpty((String)NodeListCommand.this.group) || NodeListCommand.this.group.equals(node.getGroup());
            }
        });
        this.printNodes(nodes, "", System.out);
        for (ComputeMetadata node : service.listNodes()) {
            if (!(node instanceof NodeMetadata)) continue;
            NodeMetadata metadata = (NodeMetadata)node;
            if (metadata.getState().equals((Object)NodeState.RUNNING)) {
                this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").put((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                continue;
            }
            if (metadata.getState().equals((Object)NodeState.SUSPENDED)) {
                this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").put((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").put((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                continue;
            }
            if (metadata.getState().equals((Object)NodeState.TERMINATED)) {
                this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                continue;
            }
            this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
        }
        return null;
    }
}

