/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.utils.compute;

import java.util.List;
import org.jclouds.compute.ComputeService;

public class ComputeHelper {
    public static ComputeService getComputeService(String providerOrApi, List<ComputeService> services) {
        if (providerOrApi != null) {
            ComputeService service = null;
            for (ComputeService svc : services) {
                if (!providerOrApi.equals(svc.getContext().unwrap().getId())) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("No Provider or Api named " + providerOrApi + " found.");
            }
            return service;
        }
        if (services.size() == 0) {
            throw new IllegalArgumentException("No providers are present.  Note: It takes a couple of seconds for the provider to initialize.");
        }
        if (services.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (ComputeService svc : services) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(svc.getContext().unwrap().getId());
            }
            throw new IllegalArgumentException("Multiple providers/apis are present, please select one using the --provider/--api argument in the following values: " + sb.toString());
        }
        return services.get(0);
    }

    private ComputeHelper() {
    }
}

