/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.karaf.cache.BasicCacheProvider;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.utils.EnvHelper;
import org.jclouds.karaf.utils.blobstore.BlobStoreHelper;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobStoreCommandSupport
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreCommandSupport.class);
    public static final String PROVIDERFORMAT = "%-24s %-12s %-12s";
    private List<BlobStore> services = new ArrayList<BlobStore>();
    protected CacheProvider cacheProvider = new BasicCacheProvider();
    @Option(name="--provider", description="The provider to use.")
    protected String provider;
    @Option(name="--api", description="The api to use.")
    protected String api;
    @Option(name="--identity", description="The identity to use for creating a blob store.")
    protected String identity;
    @Option(name="--credential", description="The credential to use for a blob store.")
    protected String credential;
    @Option(name="--endpoint", description="The endpoint to use for a blob store.")
    protected String endpoint;

    public Object execute(CommandSession session) throws Exception {
        try {
            this.session = session;
            return this.doExecute();
        }
        catch (AuthorizationException ex) {
            System.err.println("Authorization error. Please make sure you provided valid identity and credential.");
            return null;
        }
    }

    public void setBlobStoreServices(List<BlobStore> services) {
        this.services = services;
    }

    protected List<BlobStore> getBlobStoreServices() {
        if (this.provider == null && this.api == null) {
            return this.services;
        }
        try {
            return Collections.singletonList(this.getBlobStore());
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    protected BlobStore getBlobStore() {
        String providerOrApiValue;
        boolean canCreateService;
        String endpointValue;
        String credentialValue;
        String identityValue;
        BlobStore blobStore;
        block10: {
            if (this.services != null && this.services.size() == 1) {
                return this.services.get(0);
            }
            blobStore = null;
            String providerValue = EnvHelper.getBlobStoreProvider(this.provider);
            String apiValue = EnvHelper.getBlobStoreApi(this.api);
            identityValue = EnvHelper.getBlobStoreIdentity(this.identity);
            credentialValue = EnvHelper.getBlobStoreCredential(this.credential);
            endpointValue = EnvHelper.getBlobStoreEndpoint(this.endpoint);
            canCreateService = (!Strings.isNullOrEmpty((String)providerValue) || !Strings.isNullOrEmpty((String)apiValue)) && !Strings.isNullOrEmpty((String)identityValue) && !Strings.isNullOrEmpty((String)credentialValue);
            providerOrApiValue = !Strings.isNullOrEmpty((String)providerValue) ? providerValue : apiValue;
            try {
                blobStore = BlobStoreHelper.getBlobStore(providerOrApiValue, this.services);
            }
            catch (Throwable t) {
                if (canCreateService) break block10;
                StringBuilder sb = new StringBuilder();
                sb.append("Insufficient information to create blobstore service:").append("\n");
                if (providerOrApiValue == null) {
                    sb.append("Missing provider or api. Please specify either using the --provider / --api options, or the JCLOUDS_BLOBSTORE_PROVIDER / JCLOUDS_BLOBSTORE_API environmental variables.").append("\n");
                }
                if (identityValue == null) {
                    sb.append("Missing identity. Please specify either using the --identity option, or the JCLOUDS_BLOBSTORE_IDENTITY environmental variable.").append("\n");
                }
                if (credentialValue == null) {
                    sb.append("Missing credential. Please specify either using the --credential option, or the JCLOUDS_BLOBSTORE_CREDENTIAL environmental variable.").append("\n");
                }
                throw new RuntimeException(sb.toString());
            }
        }
        if (blobStore == null && canCreateService) {
            try {
                ContextBuilder builder = ContextBuilder.newBuilder((String)providerOrApiValue).credentials(identityValue, credentialValue).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()));
                if (!Strings.isNullOrEmpty((String)endpointValue)) {
                    builder = builder.endpoint(this.endpoint);
                }
                BlobStoreContext context = (BlobStoreContext)builder.build(BlobStoreContext.class);
                blobStore = context.getBlobStore();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create service:" + ex.getMessage());
            }
        }
        return blobStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(String containerName, String blobName) {
        Object result = null;
        ObjectInputStream ois = null;
        BlobStore blobStore = this.getBlobStore();
        blobStore.createContainerInLocation(null, containerName);
        InputStream is = blobStore.getBlob(containerName, blobName).getPayload().getInput();
        try {
            ois = new ObjectInputStream(is);
            result = ois.readObject();
        }
        catch (IOException e) {
            LOGGER.error("Error reading object.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error reading object.", (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public InputStream getBlobInputStream(BlobStore blobStore, String containerName, String blobName) throws Exception {
        if (blobStore.blobExists(containerName, blobName)) {
            return blobStore.getBlob(containerName, blobName).getPayload().getInput();
        }
        throw new Exception("Blob " + blobName + " does not exist in conatiner " + containerName + ".");
    }

    public void write(String containerName, String blobName, Object object) {
        BlobStore blobStore = this.getBlobStore();
        Blob blob = blobStore.blobBuilder(blobName).build();
        blob.setPayload(this.toBytes(object));
        blobStore.putBlob(containerName, blob);
    }

    public void write(String bucket, String blobName, InputStream is) {
        BlobStore blobStore = this.getBlobStore();
        try {
            String directory;
            if (blobName.contains("/") && !Strings.isNullOrEmpty((String)(directory = BlobStoreUtils.parseDirectoryFromPath((String)blobName)))) {
                blobStore.createDirectory(bucket, directory);
            }
            Blob blob = blobStore.blobBuilder(blobName).payload(ByteStreams.toByteArray((InputStream)is)).build();
            blobStore.putBlob(bucket, blob);
            is.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Error closing input stream.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object object) {
        byte[] result = null;
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            result = baos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Error while writing blob", (Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromUrl(URL url) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(url.openStream());
            int size = 0;
            while ((size = dis.available()) > 0) {
                byte[] buffer = new byte[size];
                baos.write(buffer);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read from stream.", (Throwable)e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
        }
        return new byte[0];
    }

    protected void printBlobStoreProviders(Map<String, ProviderMetadata> providers, List<BlobStore> blobStores, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (String provider : providers.keySet()) {
            boolean registered = false;
            for (BlobStore blobStore : blobStores) {
                if (!blobStore.getContext().unwrap().getId().equals(provider)) continue;
                registered = true;
                break;
            }
            out.println(String.format(PROVIDERFORMAT, provider, "blobstore", registered));
        }
    }

    protected void printBlobStoreApis(Map<String, ApiMetadata> apis, List<BlobStore> blobStores, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (String provider : apis.keySet()) {
            boolean registered = false;
            for (BlobStore blobStore : blobStores) {
                if (!blobStore.getContext().unwrap().getId().equals(provider)) continue;
                registered = true;
                break;
            }
            out.println(String.format(PROVIDERFORMAT, provider, "blobstore", registered));
        }
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

