/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.base.Predicate;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

@Command(scope="jclouds", name="node-destroy-all", description="Destroys all nodes.")
public class NodeDestroyAllCommand
extends ComputeCommandSupport {
    protected Object doExecute() throws Exception {
        ComputeService service = null;
        try {
            service = this.getComputeService();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
        Set nodeMetadatas = service.destroyNodesMatching((Predicate)new Predicate<NodeMetadata>(){

            public boolean apply(@Nullable NodeMetadata input) {
                return true;
            }
        });
        if (nodeMetadatas != null && !nodeMetadatas.isEmpty()) {
            System.out.println("Destroyed nodes:");
            this.printNodes(nodeMetadatas, "", System.out);
        }
        for (NodeMetadata node : nodeMetadatas) {
            this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
            this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
            this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
        }
        return null;
    }
}

