/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.collect.Sets;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

@Command(scope="jclouds", name="node-info", description="Displays detailed information about a node.")
public class NodeInfoCommand
extends ComputeCommandSupport {
    @Argument(name="id", description="The id of the node.", required=true, multiValued=false)
    private String id;

    protected Object doExecute() throws Exception {
        ComputeService service = null;
        try {
            service = this.getComputeService();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
        NodeMetadata node = service.getNodeMetadata(this.id);
        this.printNodeInfo(Sets.newHashSet((Object[])new NodeMetadata[]{node}), true, System.out);
        return null;
    }
}

