/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.base.Predicate;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.karaf.commands.compute.ComputeCommandWithOptions;

@Command(scope="jclouds", name="group-destroy", description="Destroys a group of nodes.")
public class GroupDestroyCommand
extends ComputeCommandWithOptions {
    @Argument(index=0, name="group", description="The groups of nodes to destroy.", required=true, multiValued=true)
    private List<String> groups;

    protected Object doExecute() throws Exception {
        ComputeService service = this.getComputeService();
        if (service == null) {
            System.out.println("Failed to find or create a compute service.");
            return null;
        }
        LinkedHashSet<NodeMetadata> aggregatedMetadata = new LinkedHashSet<NodeMetadata>();
        for (final String group : this.groups) {
            Set nodeMetadatas = service.destroyNodesMatching((Predicate)new Predicate<NodeMetadata>(){

                public boolean apply(@Nullable NodeMetadata input) {
                    return input.getGroup().contains(group);
                }
            });
            for (NodeMetadata node : nodeMetadatas) {
                this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").remove((Object)service.getContext().unwrap().getId(), (Object)node.getId());
                aggregatedMetadata.add(node);
            }
        }
        if (!aggregatedMetadata.isEmpty()) {
            System.out.println("Destroyed nodes:");
            this.printNodes(aggregatedMetadata, System.out);
        }
        return null;
    }
}

