/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jclouds.karaf.commands.table.ShellTable;
import org.jclouds.karaf.commands.table.ShellTableFactory;
import org.jclouds.karaf.commands.table.internal.GroovyShellTable;

public class BasicShellTableFactory
implements ShellTableFactory {
    private final Map properties = new HashMap();

    @Override
    public ShellTable build(String type) {
        String headersValue = String.valueOf(this.properties.get(type + "." + "headers"));
        String expressionsValue = String.valueOf(this.properties.get(type + "." + "expressions"));
        String alignValue = String.valueOf(this.properties.get(type + "." + "alignments"));
        String shortByValue = String.valueOf(this.properties.get(type + "." + "shortby"));
        Boolean ascendingValue = Boolean.parseBoolean(String.valueOf(this.properties.get(type + "." + "ascending")));
        List<String> headers = Arrays.asList(headersValue.split(","));
        List<String> expressions = Arrays.asList(expressionsValue.split(","));
        List<String> alignments = Arrays.asList(alignValue.split(","));
        GroovyShellTable shellTable = new GroovyShellTable();
        shellTable.setType(type);
        shellTable.setHeaders(headers);
        shellTable.setDisplayExpression(expressions);
        shellTable.setAlignments(alignments);
        shellTable.setSortBy(shortByValue);
        shellTable.setAscending(ascendingValue);
        return shellTable;
    }

    public Map getProperties() {
        return this.properties;
    }
}

