/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandBase;
import org.jclouds.karaf.utils.EnvHelper;
import org.jclouds.karaf.utils.blobstore.BlobStoreHelper;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.rest.AuthorizationException;

public abstract class BlobStoreCommandWithOptions
extends BlobStoreCommandBase {
    @Option(name="--id", description="The service id. Used to distinct between multiple service of the same provider/api. Only usable in interactive mode.")
    protected String id;
    @Option(name="--provider", description="The provider to use.")
    protected String provider;
    @Option(name="--api", description="The api to use.")
    protected String api;
    @Option(name="--identity", description="The identity to use for creating a blob store.")
    protected String identity;
    @Option(name="--credential", description="The credential to use for a blob store.")
    protected String credential;
    @Option(name="--endpoint", description="The endpoint to use for a blob store.")
    protected String endpoint;

    @Override
    public Object execute(CommandSession session) throws Exception {
        try {
            this.session = session;
            return this.doExecute();
        }
        catch (AuthorizationException ex) {
            System.err.println("Authorization error. Please make sure you provided valid identity and credential.");
            return null;
        }
    }

    @Override
    protected List<BlobStore> getBlobStoreServices() {
        if (this.provider == null && this.api == null) {
            return this.blobStoreServices;
        }
        try {
            return Collections.singletonList(this.getBlobStore());
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    protected BlobStore getBlobStore() {
        String providerOrApiValue;
        boolean canCreateService;
        String endpointValue;
        String credentialValue;
        String identityValue;
        BlobStore blobStore;
        block11: {
            if (this.id == null && this.provider == null && this.api == null && this.blobStoreServices != null && this.blobStoreServices.size() == 1) {
                return (BlobStore)this.blobStoreServices.get(0);
            }
            blobStore = null;
            String providerValue = EnvHelper.getBlobStoreProvider(this.provider);
            String apiValue = EnvHelper.getBlobStoreApi(this.api);
            identityValue = EnvHelper.getBlobStoreIdentity(this.identity);
            credentialValue = EnvHelper.getBlobStoreCredential(this.credential);
            endpointValue = EnvHelper.getBlobStoreEndpoint(this.endpoint);
            boolean serviceIdProvided = !Strings.isNullOrEmpty((String)this.id);
            canCreateService = (!Strings.isNullOrEmpty((String)providerValue) || !Strings.isNullOrEmpty((String)apiValue)) && !Strings.isNullOrEmpty((String)identityValue) && !Strings.isNullOrEmpty((String)credentialValue);
            providerOrApiValue = !Strings.isNullOrEmpty((String)providerValue) ? providerValue : apiValue;
            try {
                blobStore = BlobStoreHelper.getBlobStore(this.id, providerOrApiValue, this.blobStoreServices);
            }
            catch (Throwable t) {
                if (serviceIdProvided) {
                    throw new RuntimeException("Could not find blobstore service with id:" + this.id);
                }
                if (canCreateService) break block11;
                StringBuilder sb = new StringBuilder();
                sb.append("Insufficient information to create blobstore service:").append("\n");
                if (providerOrApiValue == null) {
                    sb.append("Missing provider or api. Please specify either using the --provider / --api options, or the JCLOUDS_BLOBSTORE_PROVIDER / JCLOUDS_BLOBSTORE_API environmental variables.").append("\n");
                }
                if (identityValue == null) {
                    sb.append("Missing identity. Please specify either using the --identity option, or the JCLOUDS_BLOBSTORE_IDENTITY environmental variable.").append("\n");
                }
                if (credentialValue == null) {
                    sb.append("Missing credential. Please specify either using the --credential option, or the JCLOUDS_BLOBSTORE_CREDENTIAL environmental variable.").append("\n");
                }
                throw new RuntimeException(sb.toString());
            }
        }
        if (blobStore == null && canCreateService) {
            try {
                ContextBuilder builder = ContextBuilder.newBuilder((String)providerOrApiValue).credentials(identityValue, credentialValue).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()));
                if (!Strings.isNullOrEmpty((String)endpointValue)) {
                    builder = builder.endpoint(this.endpoint);
                }
                BlobStoreContext context = (BlobStoreContext)builder.build(BlobStoreContext.class);
                blobStore = context.getBlobStore();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create service:" + ex.getMessage());
            }
        }
        return blobStore;
    }
}

