/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.apis.Apis;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;
import org.jclouds.karaf.utils.EnvHelper;
import org.jclouds.providers.Providers;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="jclouds", name="blobstore-service-create", description="Creates a BlobStore service.", detailedDescription="classpath:blobstore-service-create.txt")
public class BlobStoreServiceCreateCommand
extends BlobStoreCommandWithOptions {
    @Option(name="--add-option", multiValued=true, description="Adds a key value pair to the configuration.")
    protected String[] options;
    @Option(name="--no-wait", multiValued=true, description="Don't wait for blob store service registration.")
    protected boolean noWait;
    private BundleContext bundleContext;

    protected Object doExecute() throws Exception {
        if (this.provider == null && this.api == null && this.id == null) {
            System.err.println("You need to specify at least a valid provider or api.");
            return null;
        }
        if (this.id == null && this.provider != null) {
            this.id = this.provider;
        } else if (this.id == null && this.api != null) {
            this.id = this.api;
        }
        Map<String, String> props = this.parseOptions(this.options);
        this.registerBlobStore(this.configAdmin, this.id, this.provider, this.api, this.identity, this.credential, this.endpoint, props);
        if (this.noWait) {
            return null;
        }
        if (!this.isProviderOrApiInstalled(this.provider, this.api)) {
            System.out.println("Provider / api currently not installed. Service will be created once it does get installed.");
            return null;
        }
        System.out.println(String.format("Waiting for blostore service with id: %s.", this.id));
        this.waitForBlobStore(this.bundleContext, this.id, this.provider, this.api);
        return null;
    }

    private boolean isProviderOrApiInstalled(String provider, String api) {
        boolean providerOrApiFound = false;
        try {
            Providers.withId((String)provider);
            providerOrApiFound = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Apis.withId((String)api);
            providerOrApiFound = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return providerOrApiFound;
    }

    private Map<String, String> parseOptions(String[] options) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (options != null && options.length >= 1) {
            for (String option : options) {
                if (!option.contains("=")) continue;
                String key = option.substring(0, option.indexOf("="));
                String value = option.substring(option.lastIndexOf("=") + 1);
                props.put(key, value);
            }
        }
        return props;
    }

    private void registerBlobStore(final ConfigurationAdmin configurationAdmin, final String id, final String provider, final String api, final String identity, final String credential, final String endpoint, final Map<String, String> props) throws Exception {
        Runnable registrationTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Configuration configuration = BlobStoreServiceCreateCommand.this.findOrCreateFactoryConfiguration(configurationAdmin, "org.jclouds.blobstore", id, provider, api);
                    if (configuration != null) {
                        Dictionary dictionary = configuration.getProperties();
                        if (dictionary == null) {
                            dictionary = new Properties();
                        }
                        String providerValue = EnvHelper.getComputeProvider(provider);
                        String apiValue = EnvHelper.getComputeApi(api);
                        String identityValue = EnvHelper.getComputeIdentity(identity);
                        String credentialValue = EnvHelper.getComputeCredential(credential);
                        String endpointValue = EnvHelper.getComputeEndpoint(endpoint);
                        if (id != null) {
                            dictionary.put("org.jclouds.service.id", id);
                        }
                        if (providerValue != null) {
                            dictionary.put("provider", providerValue);
                        }
                        if (apiValue != null) {
                            dictionary.put("api", apiValue);
                        }
                        if (endpointValue != null) {
                            dictionary.put("endpoint", endpointValue);
                        }
                        if (credentialValue != null) {
                            dictionary.put("credential", credentialValue);
                        }
                        if (identityValue != null) {
                            dictionary.put("identity", identityValue);
                        }
                        for (Map.Entry entry : props.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            dictionary.put(key, value);
                        }
                        configuration.update(dictionary);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(registrationTask).start();
    }

    public synchronized BlobStore waitForBlobStore(BundleContext bundleContext, String id, String provider, String api) {
        BlobStore blobStore = null;
        try {
            for (int r = 0; r < 6; ++r) {
                ServiceReference[] references = null;
                if (id != null) {
                    references = bundleContext.getAllServiceReferences(BlobStore.class.getName(), "(org.jclouds.service.id=" + id + ")");
                }
                if (provider != null) {
                    references = bundleContext.getAllServiceReferences(BlobStore.class.getName(), "(provider=" + provider + ")");
                } else if (api != null) {
                    references = bundleContext.getAllServiceReferences(BlobStore.class.getName(), "(api=" + api + ")");
                }
                if (references != null && references.length > 0) {
                    blobStore = (BlobStore)bundleContext.getService((ServiceReference)references[0]);
                    return blobStore;
                }
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return blobStore;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

