/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore.completer;

import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;

public class BlobStoreApiCompleter
implements Completer {
    private final StringsCompleter delegate = new StringsCompleter();
    private List<? extends BlobStore> blobStoreServices;
    private final boolean displayApisWithoutService;

    public BlobStoreApiCompleter(boolean displayApisWithoutService) {
        this.displayApisWithoutService = displayApisWithoutService;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        try {
            if (this.displayApisWithoutService) {
                for (ApiMetadata apiMetadata : Apis.viewableAs((TypeToken)TypeToken.of(BlobStoreContext.class))) {
                    this.delegate.getStrings().add(apiMetadata.getId());
                }
            } else if (this.blobStoreServices != null) {
                for (BlobStore blobStore : this.blobStoreServices) {
                    String id = blobStore.getContext().unwrap().getId();
                    if (Apis.withId((String)id) == null) continue;
                    this.delegate.getStrings().add(id);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    public List<? extends BlobStore> getBlobStoreServices() {
        return this.blobStoreServices;
    }

    public void setBlobStoreServices(List<? extends BlobStore> blobStoreServices) {
        this.blobStoreServices = blobStoreServices;
    }
}

