/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore.completer;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.cache.Cacheable;

public abstract class BlobStoreCompleterSupport
implements Completer,
Cacheable<BlobStore> {
    private static final String ID_OPTION = "--id";
    private static final String PROVIDER_OPTION = "--provider";
    private static final String API_OPTION = "--api";
    protected final StringsCompleter delegate = new StringsCompleter();
    protected Multimap<String, String> cache;
    protected CacheProvider cacheProvider;

    public int complete(String buffer, int cursor, List<String> candidates) {
        CommandSession commandSession = CommandSessionHolder.getSession();
        ArgumentCompleter.ArgumentList list = (ArgumentCompleter.ArgumentList)commandSession.get("ARGUMENTS_LIST");
        this.delegate.getStrings().clear();
        if (list != null) {
            String serviceId = this.extractServiceId(list.getArguments());
            String providerOrApi = this.extractProviderOrApiFromArguments(list.getArguments());
            Collection values = serviceId != null && this.cache.containsKey((Object)serviceId) ? this.cache.get((Object)serviceId) : (providerOrApi != null && this.cache.containsKey((Object)providerOrApi) ? this.cache.get((Object)providerOrApi) : this.cache.values());
            for (String item : values) {
                if (buffer != null && !item.startsWith(buffer)) continue;
                this.delegate.getStrings().add(item);
            }
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    private String extractServiceId(String ... args) {
        List<String> arguments;
        String id = null;
        if (args != null && args.length > 0 && (arguments = Arrays.asList(args)).contains(ID_OPTION)) {
            int index = arguments.indexOf(ID_OPTION);
            if (arguments.size() > index) {
                return arguments.get(index + 1);
            }
        }
        return id;
    }

    private String extractProviderOrApiFromArguments(String ... args) {
        String id = null;
        if (args != null && args.length > 0) {
            int index;
            List<String> arguments = Arrays.asList(args);
            if (arguments.contains(ID_OPTION)) {
                index = arguments.indexOf(ID_OPTION);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            }
            if (arguments.contains(PROVIDER_OPTION)) {
                index = arguments.indexOf(PROVIDER_OPTION);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            } else if (arguments.contains(API_OPTION)) {
                index = arguments.indexOf(API_OPTION);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            }
        }
        return id;
    }

    protected Set<String> listContainers(BlobStore blobStore) {
        PageSet storageMetadatas;
        LinkedHashSet<String> containers = new LinkedHashSet<String>();
        if (blobStore != null && (storageMetadatas = blobStore.list()) != null && !storageMetadatas.isEmpty()) {
            for (StorageMetadata metadata : storageMetadatas) {
                containers.add(metadata.getName());
            }
        }
        return containers;
    }

    protected Set<String> listBlobs(BlobStore blobStore, String container) {
        PageSet storageMetadatas;
        LinkedHashSet<String> blobs = new LinkedHashSet<String>();
        if (blobStore != null && blobStore.containerExists(container) && (storageMetadatas = blobStore.list(container)) != null && !storageMetadatas.isEmpty()) {
            for (StorageMetadata metadata : storageMetadatas) {
                blobs.add(metadata.getName());
            }
        }
        return blobs;
    }

    public void updateOnRemoved(BlobStore blobStore) {
        this.cache.removeAll((Object)blobStore.getContext().unwrap().getId());
    }

    public Multimap<String, String> getCache() {
        return this.cache;
    }

    public void setCache(Multimap<String, String> cache) {
        this.cache = cache;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

