/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute.completer;

import java.util.Set;
import org.apache.karaf.shell.console.Completer;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.karaf.commands.compute.completer.ComputeCompleterSupport;
import org.jclouds.karaf.utils.compute.ComputeHelper;

public class ImageCompleter
extends ComputeCompleterSupport
implements Completer {
    public void init() {
        this.cache = this.cacheProvider.getProviderCacheForType("IMAGE_CACHE");
    }

    public void updateOnAdded(ComputeService computeService) {
        Set images;
        if (computeService != null && (images = computeService.listImages()) != null) {
            for (Image image : images) {
                for (String cacheKey : ComputeHelper.findCacheKeysForService(computeService)) {
                    this.cache.put((Object)cacheKey, (Object)image.getId());
                }
            }
        }
    }
}

