/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.net.URL;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-write", description="Writes data to the blobstore")
public class BlobWriteCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=false)
    String containerName;
    @Argument(index=1, name="blobName", description="The name of the blob", required=true, multiValued=false)
    String blobName;
    @Argument(index=2, name="payload", description="A url pointing to a payload, or just a string payload", required=true, multiValued=false)
    String payload;
    @Option(name="-s", aliases={"--store-url"}, description="Option to store in the blob the url itself", required=false, multiValued=false)
    boolean storeUrl;

    protected Object doExecute() throws Exception {
        BlobStore blobStore = null;
        try {
            blobStore = this.getBlobStore();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
        URL url = null;
        try {
            url = new URL(this.payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url == null || this.storeUrl) {
            this.write(this.getBlobStore(), this.containerName, this.blobName, this.payload);
            this.cacheProvider.getProviderCacheForType("container").put((Object)blobStore.getContext().unwrap().getId(), (Object)this.containerName);
            this.cacheProvider.getProviderCacheForType("blob").put((Object)blobStore.getContext().unwrap().getId(), (Object)this.blobName);
        } else {
            this.write(this.getBlobStore(), this.containerName, this.blobName, url.openStream());
            this.cacheProvider.getProviderCacheForType("container").put((Object)blobStore.getContext().unwrap().getId(), (Object)this.containerName);
            this.cacheProvider.getProviderCacheForType("blob").put((Object)blobStore.getContext().unwrap().getId(), (Object)this.blobName);
        }
        return null;
    }
}

