/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.karaf.commands.compute.ComputeCommandWithOptions;
import org.jclouds.karaf.utils.compute.ComputeHelper;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

@Command(scope="jclouds", name="node-create", description="Creates a node.", detailedDescription="classpath:node-create.txt")
public class NodeCreateCommand
extends ComputeCommandWithOptions {
    @Option(name="--adminAccess", description="Sets up a user account with passwordless sudo access and copies ssh keys.")
    private boolean adminAccess;
    @Option(name="--smallest", description="Uses the smallest possible hardware.")
    private boolean smallest;
    @Option(name="--fastest", description="Uses the fastest possible hardware.")
    private boolean fastest;
    @Option(name="--biggest", description="Uses the biggest possible hardware.")
    private boolean biggest;
    @Option(name="--hardwareId", description="Uses the hardware id specified. You can see the available values with jclouds:hardware-list.")
    private String hardwareId;
    @Option(name="--ec2-security-groups", multiValued=true)
    private List<String> ec2SecurityGroups;
    @Option(name="--ec2-key-pair")
    private String ec2KeyPair;
    @Option(name="--ec2-no-key-pair")
    private String ec2NoKeyPair;
    @Option(name="--os-family", multiValued=false, required=false, description="OS Family predicate. When using this option the command will try to find an operating system of the family provided.")
    private String osFamily;
    @Option(name="--os-version", multiValued=false, required=false, description="OS Version predicate. When using this option the command will try to find an operating system version matching the one provided.")
    private String osVersion;
    @Option(name="--imageId", multiValued=false, required=false, description="Uses the image id specified. You can see the available values with jclouds:image-list.")
    private String imageId;
    @Option(name="--locationId", multiValued=false, required=false, description="Uses the location/region specified. You can see the available values with jclouds:location-list.")
    private String locationId;
    @Argument(name="group", index=0, multiValued=false, required=true, description="Node group.")
    private String group;
    @Argument(name="number", index=1, multiValued=false, required=false, description="Number of nodes to create.")
    private Integer number = 1;

    protected Object doExecute() throws Exception {
        ComputeService service = null;
        try {
            service = this.getComputeService();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
        TemplateBuilder builder = service.templateBuilder();
        builder.any();
        if (this.smallest) {
            builder.smallest();
        }
        if (this.fastest) {
            builder.fastest();
        }
        if (this.biggest) {
            builder.biggest();
        }
        if (this.locationId != null) {
            builder.locationId(this.locationId);
        }
        if (this.imageId != null) {
            builder.imageId(this.imageId);
        }
        if (this.hardwareId != null) {
            builder.hardwareId(this.hardwareId);
        }
        if (this.osFamily != null) {
            builder.osFamily(OsFamily.fromValue((String)this.osFamily));
        }
        if (this.osVersion != null) {
            builder.osVersionMatches(this.osVersion);
        }
        TemplateOptions options = service.templateOptions();
        if (this.adminAccess) {
            options.runScript((Statement)AdminAccess.standard());
        }
        if (this.ec2SecurityGroups != null) {
            ((EC2TemplateOptions)options.as(EC2TemplateOptions.class)).securityGroups(this.ec2SecurityGroups);
        }
        if (this.ec2KeyPair != null) {
            ((EC2TemplateOptions)options.as(EC2TemplateOptions.class)).keyPair(this.ec2KeyPair);
        }
        if (this.ec2NoKeyPair != null) {
            ((EC2TemplateOptions)options.as(EC2TemplateOptions.class)).noKeyPair();
        }
        Set metadatas = null;
        try {
            metadatas = service.createNodesInGroup(this.group, this.number.intValue(), builder.options(options).build());
        }
        catch (RunNodesException ex) {
            System.out.println("Failed to create nodes:" + ex.getMessage());
        }
        if (metadatas != null && !metadatas.isEmpty()) {
            System.out.println("Created nodes:");
            this.printNodes(service, metadatas, System.out);
            for (NodeMetadata node : metadatas) {
                for (String cacheKey : ComputeHelper.findCacheKeysForService(service)) {
                    this.cacheProvider.getProviderCacheForType("ACTIVE_NODE_CACHE").put((Object)cacheKey, (Object)node.getId());
                    this.cacheProvider.getProviderCacheForType("INACTIVE_NODE_CACHE").put((Object)cacheKey, (Object)node.getId());
                    this.cacheProvider.getProviderCacheForType("SUSPENDED_NODE_CACHE").put((Object)cacheKey, (Object)node.getId());
                }
            }
        }
        return null;
    }
}

