/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-write", description="Writes data to the blobstore")
public class BlobWriteCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=false)
    String containerName;
    @Argument(index=1, name="blobName", description="The name of the blob", required=true, multiValued=false)
    String blobName;
    @Argument(index=2, name="payload", description="Payload, interpreted as a file name by default", required=true, multiValued=false)
    String payload;
    @Option(name="-s", aliases={"--string-payload"}, description="Use string payload instead of a file", required=false, multiValued=false)
    boolean stringPayload;
    @Option(name="-u", aliases={"--url-payload"}, description="Use payload from a URL instead of a file", required=false, multiValued=false)
    boolean urlPayload;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        BlobStore blobStore = null;
        try {
            blobStore = this.getBlobStore();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
        InputStream input = this.stringPayload ? new ByteArrayInputStream(this.payload.getBytes()) : (this.urlPayload ? new URL(this.payload).openStream() : new FileInputStream(this.payload));
        try {
            this.write(blobStore, this.containerName, this.blobName, input);
        }
        finally {
            Closeables.closeQuietly((Closeable)input);
        }
        this.cacheProvider.getProviderCacheForType("container").put((Object)blobStore.getContext().unwrap().getId(), (Object)this.containerName);
        this.cacheProvider.getProviderCacheForType("blob").put((Object)blobStore.getContext().unwrap().getId(), (Object)this.blobName);
        return null;
    }
}

