/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.karaf.commands.compute.RunScriptBase;
import org.jclouds.scriptbuilder.domain.Statement;

public abstract class ComputeRunscriptBase
extends RunScriptBase {
    @Option(name="-s", aliases={"--script-url"}, description="The url script of the script to run.", required=false, multiValued=false)
    private String scriptUrl;
    @Option(name="-d", aliases={"--direct"}, description="A direct command passed to the node to run. Example: jclouds:xxxx-runscript -d uptime xxxx. ", required=false, multiValued=false)
    private String directCommand;
    @Option(name="-r", aliases={"--run-as-root"}, description="Flag to execute script as root. ", required=false, multiValued=false)
    private boolean runAsRoot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getScript() {
        if (this.directCommand != null) {
            return this.directCommand;
        }
        if (this.scriptUrl != null) {
            InputStream is = null;
            FilterInputStream in = null;
            BufferedReader br = null;
            StringBuilder builder = new StringBuilder();
            try {
                URL url = new URL(this.scriptUrl);
                is = url.openStream();
                in = new DataInputStream(is);
                br = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while ((line = br.readLine()) != null) {
                    builder.append(line).append("\n");
                }
                String string = builder.toString();
                return string;
            }
            catch (MalformedURLException e) {
                System.err.println("The provided script url is invalid.");
            }
            catch (IOException e) {
                System.err.println("Cannot read script from url.");
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception ex) {}
                try {
                    in.close();
                }
                catch (Exception ex) {}
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return "";
    }

    @Override
    public Statement getStatement() {
        return null;
    }

    @Override
    public boolean runAsRoot() {
        return this.runAsRoot;
    }
}

