/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.apis.Apis;
import org.jclouds.compute.ComputeService;
import org.jclouds.karaf.commands.compute.ComputeCommandWithOptions;
import org.jclouds.karaf.utils.EnvHelper;
import org.jclouds.providers.Providers;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="jclouds", name="compute-service-create", description="Creates a compute service", detailedDescription="classpath:compute-service-create.txt")
public class ComputeServiceCreateCommand
extends ComputeCommandWithOptions {
    @Option(name="--add-option", multiValued=true, description="Adds a key value pair to the configuration.")
    protected String[] options;
    @Option(name="--no-wait", multiValued=true, description="Don't wait for compute service registration.")
    protected boolean noWait;
    private BundleContext bundleContext;

    protected Object doExecute() throws Exception {
        if (this.provider == null && this.api == null) {
            System.err.println("You need to specify at least a valid provider or api.");
            return null;
        }
        if (this.name == null && this.provider != null) {
            this.name = this.provider;
        } else if (this.name == null && this.api != null) {
            this.name = this.api;
        }
        Map<String, String> props = this.parseOptions(this.options);
        this.registerComputeService(this.configAdmin, this.name, this.provider, this.api, this.identity, this.credential, this.endpoint, props);
        if (this.noWait) {
            return null;
        }
        if (!this.isProviderOrApiInstalled(this.provider, this.api)) {
            System.out.println("Provider / api currently not installed. Service will be created once it does get installed.");
            return null;
        }
        System.out.println(String.format("Waiting for compute service with name: %s.", this.name));
        this.waitForComputeService(this.bundleContext, this.name, this.provider, this.api);
        return null;
    }

    private boolean isProviderOrApiInstalled(String provider, String api) {
        boolean providerOrApiFound = false;
        try {
            Providers.withId((String)provider);
            providerOrApiFound = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Apis.withId((String)api);
            providerOrApiFound = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return providerOrApiFound;
    }

    private Map<String, String> parseOptions(String[] options) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (options != null && options.length >= 1) {
            for (String option : options) {
                if (!option.contains("=")) continue;
                String key = option.substring(0, option.indexOf("="));
                String value = option.substring(option.lastIndexOf("=") + 1);
                props.put(key, value);
            }
        }
        return props;
    }

    private void registerComputeService(final ConfigurationAdmin configurationAdmin, final String name, final String provider, final String api, final String identity, final String credential, final String endpoint, final Map<String, String> props) throws Exception {
        Runnable registrationTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Configuration configuration = ComputeServiceCreateCommand.this.findOrCreateFactoryConfiguration(configurationAdmin, "org.jclouds.compute", name, provider, api);
                    if (configuration != null) {
                        Dictionary dictionary = configuration.getProperties();
                        if (dictionary == null) {
                            dictionary = new Properties();
                        }
                        String providerValue = EnvHelper.getComputeProvider(provider);
                        String apiValue = EnvHelper.getComputeApi(api);
                        String identityValue = EnvHelper.getComputeIdentity(identity);
                        String credentialValue = EnvHelper.getComputeCredential(credential);
                        String endpointValue = EnvHelper.getComputeEndpoint(endpoint);
                        if (name != null) {
                            dictionary.put("name", name);
                        }
                        if (providerValue != null) {
                            dictionary.put("provider", providerValue);
                        }
                        if (apiValue != null) {
                            dictionary.put("api", apiValue);
                        }
                        if (endpointValue != null) {
                            dictionary.put("endpoint", endpointValue);
                        }
                        if (credentialValue != null) {
                            dictionary.put("credential", credentialValue);
                        }
                        if (identityValue != null) {
                            dictionary.put("identity", identityValue);
                        }
                        for (Map.Entry entry : props.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            dictionary.put(key, value);
                        }
                        configuration.update(dictionary);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(registrationTask).start();
    }

    public synchronized ComputeService waitForComputeService(BundleContext bundleContext, String name, String provider, String api) {
        ComputeService computeService = null;
        try {
            for (int r = 0; r < 6; ++r) {
                ServiceReference[] references = null;
                if (name != null) {
                    references = bundleContext.getAllServiceReferences(ComputeService.class.getName(), "(name=" + name + ")");
                } else if (provider != null) {
                    references = bundleContext.getAllServiceReferences(ComputeService.class.getName(), "(provider=" + provider + ")");
                } else if (api != null) {
                    references = bundleContext.getAllServiceReferences(ComputeService.class.getName(), "(api=" + api + ")");
                }
                if (references != null && references.length > 0) {
                    computeService = (ComputeService)bundleContext.getService((ServiceReference)references[0]);
                    return computeService;
                }
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return computeService;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

