/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.table;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jclouds.karaf.commands.table.ShellTable;
import org.jclouds.karaf.commands.table.internal.AlphanumericComparator;

public abstract class BasicShellTable<D>
implements ShellTable<D> {
    private String type;
    private List<String> headers;
    private List<String> displayExpression;
    private List<String> alignments;
    private String sortBy;
    private boolean ascending;
    private D displayData;
    private final Comparator comparator = new AlphanumericComparator();

    @Override
    public abstract String evaluate(Object var1, String var2);

    @Override
    public void display(PrintStream out, boolean showHeaders, boolean showData) {
        ArrayList<String[]> table = new ArrayList<String[]>();
        Iterable iterableData = null;
        iterableData = Iterable.class.isAssignableFrom(this.displayData.getClass()) ? (Iterable)this.displayData : Lists.newArrayList((Object[])new Object[]{this.displayData});
        for (Object obj : iterableData) {
            String[] values = new String[this.displayExpression.size()];
            for (int i = 0; i < this.displayExpression.size(); ++i) {
                values[i] = this.evaluate(obj, this.displayExpression.get(i));
            }
            table.add(values);
        }
        List<Integer> sizes = this.calculateSizes(this.headers, table);
        if (!Strings.isNullOrEmpty((String)this.sortBy) && this.headers.contains(this.sortBy)) {
            Collections.sort(table, new Comparator<String[]>(){

                @Override
                public int compare(String[] left, String[] right) {
                    int column = BasicShellTable.this.headers.indexOf(BasicShellTable.this.sortBy);
                    String leftValue = left[column];
                    String rightValue = right[column];
                    return BasicShellTable.this.comparator.compare(leftValue, rightValue);
                }
            });
        }
        String dataFormat = this.getStringFormat(sizes, this.alignments);
        if (showHeaders) {
            out.println(String.format(dataFormat, this.headers.toArray(new String[this.headers.size()])));
        }
        if (showData && table != null) {
            for (Object[] objectArray : table) {
                out.println(String.format(dataFormat, objectArray));
            }
        }
    }

    private List<Integer> calculateSizes(List<String> headers, List<String[]> displayData) {
        LinkedList<Integer> sizes = new LinkedList<Integer>();
        for (int i = 0; i < headers.size(); ++i) {
            String header = headers.get(i);
            int size = header.length();
            for (String[] row : displayData) {
                String value = row[i];
                int valueSize = value.length();
                size = size > valueSize ? size : valueSize;
            }
            sizes.add(size);
        }
        return sizes;
    }

    private String getStringFormat(List<Integer> sizes, List<String> alignments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sizes.size(); ++i) {
            String alignment;
            if (i > 0) {
                sb.append(" ");
            }
            int size = sizes.get(i);
            String string = alignment = alignments != null && alignments.size() > i ? alignments.get(i) : "left";
            if ("right".equals(alignment)) {
                sb.append("%").append(size).append("s");
                continue;
            }
            sb.append("%-").append(size).append("s");
        }
        return sb.toString();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public List<String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    @Override
    public List<String> getDisplayExpression() {
        return this.displayExpression;
    }

    @Override
    public void setDisplayExpression(List<String> displayExpression) {
        this.displayExpression = displayExpression;
    }

    @Override
    public List<String> getAlignments() {
        return this.alignments;
    }

    @Override
    public void setAlignments(List<String> alignments) {
        this.alignments = alignments;
    }

    @Override
    public String getSortBy() {
        return this.sortBy;
    }

    @Override
    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public boolean getAscending() {
        return this.ascending;
    }

    @Override
    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    @Override
    public D getDisplayData() {
        return this.displayData;
    }

    @Override
    public void setDisplayData(D displayData) {
        this.displayData = displayData;
    }
}

