/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.domain.Location;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-create-container", description="Creates a container")
public class BlobCreateCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerNames", description="The name of the container", required=true, multiValued=true)
    List<String> containerNames;
    @Option(name="-l", aliases={"--location"}, description="Location to create container in", required=false, multiValued=false)
    String locationString = "";

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        Location location = null;
        if (!this.locationString.isEmpty()) {
            for (Location loc : blobStore.listAssignableLocations()) {
                if (!loc.getId().equalsIgnoreCase(this.locationString)) continue;
                location = loc;
                break;
            }
            if (location == null) {
                throw new IllegalArgumentException("unknown location: " + this.locationString);
            }
        }
        for (String container : this.containerNames) {
            boolean created = blobStore.createContainerInLocation(location, container);
            if (created) continue;
            throw new Exception("Could not create container: " + container);
        }
        return null;
    }
}

