/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.util.LinkedList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-remove", description="Removes blobs")
public class BlobRemoveCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="container", description="The name of the container", required=true)
    String container;
    @Argument(index=1, name="blobNames", description="The names of the blobs", required=true, multiValued=true)
    List<String> blobNames = new LinkedList<String>();

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        for (String blobName : this.blobNames) {
            if (!blobStore.blobExists(this.container, blobName)) continue;
            blobStore.removeBlob(this.container, blobName);
            this.cacheProvider.getProviderCacheForType("blob").remove((Object)blobStore.getContext().unwrap().getId(), (Object)blobName);
        }
        return null;
    }
}

