/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.Processor;
import org.jclouds.domain.Location;
import org.jclouds.karaf.cache.BasicCacheProvider;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.commands.table.ShellTable;
import org.jclouds.karaf.commands.table.ShellTableFactory;
import org.jclouds.karaf.commands.table.internal.PropertyShellTableFactory;
import org.jclouds.karaf.utils.ServiceHelper;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.AuthorizationException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class ComputeCommandBase
extends AbstractAction {
    public static final String NODE_DETAILS_FORMAT = "%20s %-60s";
    public static final String PROVIDERFORMAT = "%-24s %-12s %-12s";
    public static final String FACTORY_FILTER = "(service.factoryPid=%s)";
    protected ConfigurationAdmin configAdmin;
    protected CacheProvider cacheProvider = new BasicCacheProvider();
    protected List<ComputeService> computeServices = new ArrayList<ComputeService>();
    protected ShellTableFactory shellTableFactory = new PropertyShellTableFactory();

    public Object execute(CommandSession session) throws Exception {
        try {
            this.session = session;
            return this.doExecute();
        }
        catch (AuthorizationException ex) {
            System.err.println(String.format("Authorization error: %s", ex.getMessage()));
            return null;
        }
    }

    protected void printComputeProviders(Iterable<ProviderMetadata> providers, List<ComputeService> computeServices, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (ProviderMetadata provider : providers) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            for (ComputeService computeService : computeServices) {
                String contextName = computeService.getContext().unwrap().getName();
                if (!computeService.getContext().unwrap().getId().equals(provider.getId()) || contextName == null) continue;
                sb.append(contextName).append(" ");
            }
            sb.append("]");
            out.println(String.format(PROVIDERFORMAT, provider.getId(), "compute", sb.toString()));
        }
    }

    protected void printComputeApis(Iterable<ApiMetadata> apis, List<ComputeService> computeServices, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (ApiMetadata api : apis) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            for (ComputeService computeService : computeServices) {
                String contextName = computeService.getContext().unwrap().getName();
                if (!computeService.getContext().unwrap().getId().equals(api.getId()) || contextName == null) continue;
                sb.append(contextName).append(" ");
            }
            sb.append("]");
            out.println(String.format(PROVIDERFORMAT, api.getId(), "compute", sb.toString()));
        }
    }

    protected void printNodes(ComputeService service, Set<? extends ComputeMetadata> nodes, PrintStream out) {
        ShellTable table = this.shellTableFactory.build("node");
        table.setDisplayData(nodes);
        table.display(out, true, true);
        for (ComputeMetadata computeMetadata : nodes) {
            NodeMetadata node = (NodeMetadata)computeMetadata;
            for (String cacheKey : ServiceHelper.findCacheKeysForService(service)) {
                this.cacheProvider.getProviderCacheForType("GROUP").put((Object)cacheKey, (Object)node.getGroup());
            }
        }
    }

    protected void printHardwares(ComputeService service, Set<? extends Hardware> hardwares, PrintStream out) {
        ShellTable table = this.shellTableFactory.build("hardware");
        table.setDisplayData(hardwares);
        table.display(out, true, true);
        for (Hardware hardware : hardwares) {
            for (String cacheKey : ServiceHelper.findCacheKeysForService(service)) {
                this.cacheProvider.getProviderCacheForType("HARDWARE_CACHE").put((Object)cacheKey, (Object)hardware.getId());
            }
        }
    }

    protected void printImages(ComputeService service, Set<? extends Image> images, PrintStream out) {
        ShellTable table = this.shellTableFactory.build("image");
        table.setDisplayData(images);
        table.display(out, true, true);
        for (Image image : images) {
            for (String cacheKey : ServiceHelper.findCacheKeysForService(service)) {
                this.cacheProvider.getProviderCacheForType("IMAGE_CACHE").put((Object)cacheKey, (Object)image.getId());
            }
        }
    }

    protected void printLocations(ComputeService computeService, PrintStream out) {
        ShellTable table = this.shellTableFactory.build("location");
        table.setDisplayData(this.getAllLocations(computeService));
        table.display(out, true, true);
    }

    protected Set<? extends Location> getAllLocations(ComputeService computeService) {
        HashSet<Location> all = new HashSet<Location>();
        Iterator i$ = computeService.listAssignableLocations().iterator();
        while (i$.hasNext()) {
            Location loc;
            for (Location p = loc = (Location)i$.next(); p != null; p = p.getParent()) {
                all.add(p);
                for (String cacheKey : ServiceHelper.findCacheKeysForService(computeService)) {
                    this.cacheProvider.getProviderCacheForType("LOCATION_CACHE").put((Object)cacheKey, (Object)p.getId());
                }
            }
        }
        return all;
    }

    protected String getOperatingSystemDetails(NodeMetadata node) {
        OperatingSystem os;
        if (node != null && (os = node.getOperatingSystem()) != null) {
            return node.getOperatingSystem().getFamily().value() + " " + node.getOperatingSystem().getArch() + " " + node.getOperatingSystem().getVersion();
        }
        return "";
    }

    protected String getPublicAddresses(NodeMetadata node) {
        StringBuilder sb = new StringBuilder();
        if (node != null && node.getPublicAddresses() != null && !node.getPublicAddresses().isEmpty()) {
            Set publicAddresses = node.getPublicAddresses();
            Iterator addressIterator = publicAddresses.iterator();
            while (addressIterator.hasNext()) {
                sb.append((String)addressIterator.next());
                if (!addressIterator.hasNext()) continue;
                sb.append(" , ");
            }
        }
        return sb.toString();
    }

    protected String getPrivateAddresses(NodeMetadata node) {
        StringBuilder sb = new StringBuilder();
        if (node != null && node.getPrivateAddresses() != null && !node.getPrivateAddresses().isEmpty()) {
            Set privateAddresses = node.getPrivateAddresses();
            Iterator addressIterator = privateAddresses.iterator();
            while (addressIterator.hasNext()) {
                sb.append((String)addressIterator.next());
                if (!addressIterator.hasNext()) continue;
                sb.append(" , ");
            }
        }
        return sb.toString();
    }

    protected void printNodeInfo(ComputeService service, Set<? extends NodeMetadata> nodes, boolean details, PrintStream out) {
        this.printNodes(service, nodes, out);
        if (details) {
            for (NodeMetadata nodeMetadata : nodes) {
                out.println();
                out.println(String.format(NODE_DETAILS_FORMAT, "Operating System:", this.getOperatingSystemDetails(nodeMetadata)));
                out.println(String.format(NODE_DETAILS_FORMAT, "Configured User:", nodeMetadata.getCredentials() != null ? nodeMetadata.getCredentials().getUser() : "n/a"));
                out.println(String.format(NODE_DETAILS_FORMAT, "Public Address:", this.getPublicAddresses(nodeMetadata)));
                out.println(String.format(NODE_DETAILS_FORMAT, "Private Address:", this.getPrivateAddresses(nodeMetadata)));
                out.println(String.format(NODE_DETAILS_FORMAT, "Image Id:", nodeMetadata.getImageId()));
            }
        }
    }

    protected Configuration findOrCreateFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, String id, String provider, String api) throws IOException {
        Configuration configuration = null;
        if (configurationAdmin != null) {
            try {
                Configuration[] configurations = configurationAdmin.listConfigurations(String.format(FACTORY_FILTER, factoryPid));
                if (configurations != null) {
                    for (Configuration conf : configurations) {
                        Dictionary dictionary = conf.getProperties();
                        if (dictionary != null && id != null) {
                            if (!id.equals(dictionary.get("name"))) continue;
                            return conf;
                        }
                        if (dictionary != null && provider != null && provider.equals(dictionary.get("provider"))) {
                            return conf;
                        }
                        if (dictionary == null || api == null || !api.equals(dictionary.get("api"))) continue;
                        return conf;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            configuration = configurationAdmin.createFactoryConfiguration(factoryPid, null);
        }
        return configuration;
    }

    protected double getMemory(Hardware hardware) {
        return hardware.getRam();
    }

    protected double getCpuCores(Hardware hardware) {
        int nb = 0;
        for (Processor p : hardware.getProcessors()) {
            nb = (int)((double)nb + p.getCores());
        }
        return nb;
    }

    protected double getCpuUnits(Hardware hardware) {
        double nb = 0.0;
        for (Processor p : hardware.getProcessors()) {
            nb += p.getCores() * p.getSpeed();
        }
        return nb;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public List<ComputeService> getComputeServices() {
        return this.computeServices;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }

    public ShellTableFactory getShellTableFactory() {
        return this.shellTableFactory;
    }

    public void setShellTableFactory(ShellTableFactory shellTableFactory) {
        this.shellTableFactory = shellTableFactory;
    }
}

