/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.utils;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.jclouds.Context;
import org.jclouds.View;

public class ServiceHelper {
    private ServiceHelper() {
    }

    public static <T> List<String> findCacheKeysForService(T service) {
        LinkedList<String> keys = new LinkedList<String>();
        String contextName = ServiceHelper.toName(service);
        String providerOrApi = ServiceHelper.toId(service);
        if (contextName != null) {
            keys.add(contextName);
        }
        if (providerOrApi != null) {
            keys.add(providerOrApi);
        }
        return keys;
    }

    public static <T> T getService(String id, String providerOrApi, List<T> services) {
        if (!Strings.isNullOrEmpty((String)id)) {
            T service = null;
            for (T svc : services) {
                if (!id.equals(ServiceHelper.toName(svc))) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("No service with id" + id + " found.");
            }
            return service;
        }
        if (!Strings.isNullOrEmpty((String)providerOrApi)) {
            T service = null;
            for (T svc : services) {
                if (!providerOrApi.equals(ServiceHelper.toId(svc))) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("No Provider or Api named " + providerOrApi + " found.");
            }
            return service;
        }
        if (services.size() == 0) {
            throw new IllegalArgumentException("No providers are present.  Note: It takes a couple of seconds for the provider to initialize.");
        }
        if (services.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (T svc : services) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(ServiceHelper.toId(svc));
            }
            throw new IllegalArgumentException("Multiple providers/apis are present, please select one using the --provider/--api argument in the following values: " + sb.toString());
        }
        return services.get(0);
    }

    public static <T> String toId(T service) {
        String id = null;
        try {
            Context context = ServiceHelper.toContext(service);
            id = View.class.isAssignableFrom(context.getClass()) ? ((View)context).unwrap().getId() : context.getId();
        }
        catch (IllegalArgumentException ex) {
            id = ServiceHelper.callMethod(service, "getId", String.class);
        }
        return id;
    }

    public static <T> String toName(T service) {
        String name = null;
        try {
            Context context = ServiceHelper.toContext(service);
            name = View.class.isAssignableFrom(context.getClass()) ? ((View)context).unwrap().getName() : context.getId();
        }
        catch (IllegalArgumentException ex) {
            name = ServiceHelper.callMethod(service, "getName", String.class);
        }
        return name;
    }

    public static <T> Context toContext(T service) {
        Context ctx;
        block6: {
            ctx = null;
            Class<?> c = service.getClass();
            try {
                Method m = c.getMethod("getContext", new Class[0]);
                Object obj = m.invoke(service, new Object[0]);
                if (Context.class.isAssignableFrom(obj.getClass())) {
                    ctx = (Context)obj;
                    break block6;
                }
                if (View.class.isAssignableFrom(obj.getClass())) {
                    ctx = ((View)obj).unwrap();
                    break block6;
                }
                throw new IllegalArgumentException("Service doesn't have a context.");
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return ctx;
    }

    public static <S, T> T callMethod(S service, String methodNane, Class<T> returnType) {
        T result = null;
        Class<?> c = service.getClass();
        try {
            Method m = c.getMethod(methodNane, new Class[0]);
            Object obj = m.invoke(service, new Object[0]);
            if (!returnType.isAssignableFrom(obj.getClass())) {
                throw new IllegalArgumentException("Service doesn't have a context.");
            }
            result = returnType.cast(obj);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }
}

