/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-list", description="Lists blobs in a container")
public class BlobListCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerNames", description="The name of the container", required=false, multiValued=true)
    final Collection<String> containerNames = Lists.newArrayList();
    @Option(name="-a", aliases={"--all"}, description="List all containers", required=false)
    boolean listAllContainers = false;
    private static final PrintStream out = System.out;

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        if (this.listAllContainers) {
            this.containerNames.clear();
            for (StorageMetadata containerMetadata : blobStore.list()) {
                String containerName = containerMetadata.getName();
                this.containerNames.add(containerName);
                this.cacheProvider.getProviderCacheForType("container").put((Object)containerMetadata.getProviderId(), (Object)containerName);
            }
        } else if (this.containerNames.isEmpty()) {
            throw new CommandException("Must specify container names or --all");
        }
        for (String containerName : this.containerNames) {
            out.println(containerName + ":");
            out.println();
            ListContainerOptions options = ListContainerOptions.Builder.recursive();
            while (true) {
                PageSet blobStoreMetadatas = blobStore.list(containerName, options);
                ArrayList blobNames = Lists.newArrayList();
                for (StorageMetadata blobMetadata : blobStoreMetadatas) {
                    String blobName = blobMetadata.getName();
                    this.cacheProvider.getProviderCacheForType("blob").put((Object)blobMetadata.getProviderId(), (Object)blobName);
                    blobNames.add(blobName);
                }
                Collections.sort(blobNames);
                for (String blobName : blobNames) {
                    out.println("    " + blobName);
                }
                String marker = blobStoreMetadatas.getNextMarker();
                if (marker == null) break;
                options = options.afterMarker(marker);
            }
            out.println();
        }
        return null;
    }
}

