/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.io.ContentMetadata;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-blob-metadata", description="Print blob metadata")
public class BlobMetadataCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true)
    String containerName;
    @Argument(index=1, name="blobNames", description="The name of the blobs", required=true, multiValued=true)
    List<String> blobNames = Lists.newArrayList();
    private static final PrintStream out = System.out;

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        for (String blobName : this.blobNames) {
            BlobMetadata blobMetadata = blobStore.blobMetadata(this.containerName, blobName);
            if (blobMetadata == null) {
                throw new KeyNotFoundException(this.containerName, blobName, "while getting metadata");
            }
            ContentMetadata contentMetdata = blobMetadata.getContentMetadata();
            out.println(blobName + ":");
            BlobMetadataCommand.printMetadata("Content-Disposition", contentMetdata.getContentDisposition());
            BlobMetadataCommand.printMetadata("Content-Encoding", contentMetdata.getContentEncoding());
            BlobMetadataCommand.printMetadata("Content-Language", contentMetdata.getContentLanguage());
            byte[] contentMD5 = contentMetdata.getContentMD5();
            if (contentMD5 != null) {
                BlobMetadataCommand.printMetadata("Content-MD5", BaseEncoding.base16().lowerCase().encode(contentMD5));
            }
            BlobMetadataCommand.printMetadata("Content-Type", contentMetdata.getContentType());
            BlobMetadataCommand.printMetadata("Expires", contentMetdata.getExpires());
            BlobMetadataCommand.printMetadata("Length", contentMetdata.getContentLength());
            out.println("");
        }
        return null;
    }

    private static void printMetadata(String key, Object value) {
        if (value != null) {
            out.println(String.format("    %s: %s", key, value));
        }
    }
}

