/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-read", description="Reads data from the blobstore")
public class BlobReadCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=false)
    String containerName;
    @Argument(index=1, name="blobName", description="The name of the blob", required=true, multiValued=false)
    String blobName;
    @Argument(index=2, name="toFile", description="The file to store the blob", required=false, multiValued=false)
    String fileName;
    @Option(name="-d", aliases={"--display"}, description="Display the content to the console", required=false, multiValued=false)
    boolean display;
    @Option(name="-e", aliases={"--exists"}, description="Test whether a blob exists", required=false, multiValued=false)
    boolean exists;

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        if (this.exists) {
            if (!blobStore.blobExists(this.containerName, this.blobName)) {
                throw new KeyNotFoundException(this.containerName, this.blobName, "while checking existence");
            }
            return null;
        }
        InputSupplier<InputStream> supplier = this.getBlobInputStream(blobStore, this.containerName, this.blobName);
        if (this.display) {
            CharStreams.copy((InputSupplier)CharStreams.newReaderSupplier(supplier, (Charset)Charsets.UTF_8), (Appendable)System.err);
            System.err.flush();
        } else {
            File file = new File(this.fileName);
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Could not create: " + file);
            }
            Files.copy(supplier, (File)file);
        }
        return null;
    }
}

