/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-container-clear", description="Clears a container")
public class ContainerClearCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerNames", description="The name of the container", required=true, multiValued=true)
    List<String> containerNames = Lists.newLinkedList();

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        for (String container : this.containerNames) {
            blobStore.clearContainer(container);
        }
        return null;
    }
}

