/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-container-exists", description="Test whether a container exists")
public class ContainerExistsCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerNames", description="The name of the container", required=true, multiValued=true)
    final List<String> containerNames = Lists.newLinkedList();

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        for (String container : this.containerNames) {
            if (blobStore.containerExists(container)) continue;
            throw new ContainerNotFoundException(container, "while checking existence");
        }
        return null;
    }
}

