/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.karaf.commands.compute.ComputeCommandWithOptions;
import org.jclouds.karaf.utils.EnvHelper;
import org.jclouds.scriptbuilder.domain.Statement;

public abstract class RunScriptBase
extends ComputeCommandWithOptions {
    @Option(name="-u", aliases={"--user"}, description="The user that will run the script.", required=false, multiValued=false)
    protected String user;
    @Option(name="-p", aliases={"--password"}, description="Optional password for the user to run the script.", required=false, multiValued=false)
    protected String password;

    public abstract String getId();

    public abstract String getGroup();

    public abstract String getScript();

    public abstract Statement getStatement();

    public abstract boolean runAsRoot();

    protected Object doExecute() throws Exception {
        ComputeService service = null;
        try {
            service = this.getComputeService();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            return null;
        }
        Set nodeMetaDataSet = service.listNodesDetailsMatching(this.getComputeFilter());
        if (nodeMetaDataSet != null && !nodeMetaDataSet.isEmpty()) {
            NodeMetadata nodeMetadata = nodeMetaDataSet.toArray(new NodeMetadata[0])[0];
            this.printNodeInfo(service, nodeMetaDataSet, nodeMetaDataSet.size() == 1, System.out);
            LoginCredentials credentials = nodeMetadata.getCredentials();
            this.user = EnvHelper.getUser(this.user);
            this.password = EnvHelper.getPassword(this.password);
            if (this.user != null) {
                LoginCredentials.Builder loginBuilder = credentials == null ? LoginCredentials.builder() : credentials.toBuilder();
                credentials = this.password != null ? loginBuilder.user(this.user).password(this.password).build() : loginBuilder.user(this.user).build();
            }
            Map responseMap = null;
            if (this.getScript() != null) {
                responseMap = service.runScriptOnNodesMatching(this.getNodeFilter(), this.getScript(), RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(this.runAsRoot()));
            } else if (this.getStatement() != null) {
                responseMap = service.runScriptOnNodesMatching(this.getNodeFilter(), this.getStatement(), RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(this.runAsRoot()));
            }
            for (Map.Entry entry : responseMap.entrySet()) {
                ExecResponse response = (ExecResponse)entry.getValue();
                NodeMetadata node = (NodeMetadata)entry.getKey();
                System.out.println("");
                if (response.getOutput() != null && !response.getOutput().isEmpty()) {
                    System.out.println("Node:" + node.getId() + " Output:" + response.getOutput());
                }
                if (response.getError() == null || response.getError().isEmpty()) continue;
                System.out.println("Node:" + node.getId() + " Error:" + response.getError());
            }
        }
        return null;
    }

    public Predicate<NodeMetadata> getNodeFilter() {
        return new Predicate<NodeMetadata>(){

            public boolean apply(@Nullable NodeMetadata input) {
                boolean applies = true;
                if (!((NodeMetadata.Status)input.getStatus()).equals((Object)NodeMetadata.Status.RUNNING)) {
                    return false;
                }
                if (RunScriptBase.this.getId() != null && !RunScriptBase.this.getId().isEmpty() && !input.getId().equals(RunScriptBase.this.getId())) {
                    applies = false;
                }
                if (RunScriptBase.this.getGroup() != null && !RunScriptBase.this.getGroup().isEmpty() && !input.getGroup().equals(RunScriptBase.this.getGroup())) {
                    applies = false;
                }
                return applies;
            }
        };
    }

    public Predicate<ComputeMetadata> getComputeFilter() {
        return new Predicate<ComputeMetadata>(){

            public boolean apply(@Nullable ComputeMetadata input) {
                boolean applies = true;
                if (input instanceof NodeMetadata) {
                    if (!((NodeMetadata.Status)((NodeMetadata)input).getStatus()).equals((Object)NodeMetadata.Status.RUNNING)) {
                        return false;
                    }
                    if (RunScriptBase.this.getId() != null && !RunScriptBase.this.getId().isEmpty() && !RunScriptBase.this.getId().equals(input.getId())) {
                        applies = false;
                    }
                    if (RunScriptBase.this.getGroup() != null && !RunScriptBase.this.getGroup().isEmpty() && RunScriptBase.this.getGroup().equals(((NodeMetadata)input).getGroup())) {
                        applies = false;
                    }
                }
                return applies;
            }
        };
    }
}

