/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.core.internal;

import com.google.common.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.karaf.core.BlobStoreProviderListener;
import org.jclouds.karaf.core.ComputeProviderListener;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderPredicates;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderBundleListener
implements BundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderBundleListener.class);
    private Set<ProviderMetadata> computeProviders = new HashSet<ProviderMetadata>();
    private Set<ProviderMetadata> blobStoreProviders = new HashSet<ProviderMetadata>();
    private final List<ComputeProviderListener> computeListeners = new LinkedList<ComputeProviderListener>();
    private final List<BlobStoreProviderListener> blobStoreListeners = new LinkedList<BlobStoreProviderListener>();
    private BundleContext bundleContext;

    public void init() {
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            ProviderMetadata metadata = this.getProviderMetadata(bundle);
            this.notifyListeners(metadata);
        }
    }

    public void destroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public void notifyListeners(ProviderMetadata metadata) {
        block2: {
            block3: {
                if (metadata == null) break block2;
                if (!ProviderPredicates.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class)).apply((Object)metadata)) break block3;
                this.computeProviders.add(metadata);
                for (ComputeProviderListener providerListener : this.computeListeners) {
                    providerListener.providerInstalled(metadata);
                }
                break block2;
            }
            if (!ProviderPredicates.viewableAs((TypeToken)TypeToken.of(BlobStoreContext.class)).apply((Object)metadata)) break block2;
            this.blobStoreProviders.add(metadata);
            for (BlobStoreProviderListener providerListener : this.blobStoreListeners) {
                providerListener.providerInstalled(metadata);
            }
        }
    }

    private void removeListeners(ProviderMetadata metadata) {
        block2: {
            block3: {
                if (metadata == null) break block2;
                if (!ProviderPredicates.viewableAs((TypeToken)TypeToken.of(ComputeServiceContext.class)).apply((Object)metadata)) break block3;
                this.computeProviders.remove(metadata);
                for (ComputeProviderListener providerListener : this.computeListeners) {
                    providerListener.providerUninstalled(metadata);
                }
                break block2;
            }
            if (!ProviderPredicates.viewableAs((TypeToken)TypeToken.of(BlobStoreContext.class)).apply((Object)metadata)) break block2;
            this.blobStoreProviders.remove(metadata);
            for (BlobStoreProviderListener providerListener : this.blobStoreListeners) {
                providerListener.providerUninstalled(metadata);
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                ProviderMetadata metadata = this.getProviderMetadata(event.getBundle());
                this.notifyListeners(metadata);
            }
        }
    }

    public ProviderMetadata getProviderMetadata(Bundle bundle) {
        ProviderMetadata metadata = null;
        String className = this.getProviderMetadataClassName(bundle);
        if (className != null && !className.isEmpty()) {
            try {
                Class provideClass = bundle.loadClass(className);
                metadata = (ProviderMetadata)provideClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not load provider metadata class.", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.warn("Could not instantiate metadata class:" + className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Could not instantiate metadata class:" + className, (Throwable)e);
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProviderMetadataClassName(Bundle bundle) {
        URL resource = bundle.getEntry("/META-INF/services/org.jclouds.providers.ProviderMetadata");
        InputStream is = null;
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            is = resource.openStream();
            reader = new InputStreamReader(is, "UTF-8");
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (Throwable e) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Throwable e) {}
            try {
                is.close();
            }
            catch (Throwable e) {}
        }
        return sb.toString().trim();
    }

    public void registerComputeListener(ComputeProviderListener providerListener) {
        this.computeListeners.add(providerListener);
        for (ProviderMetadata provider : this.computeProviders) {
            providerListener.providerInstalled(provider);
        }
    }

    public void unregisterComputeListener(ComputeProviderListener providerListener) {
        this.computeListeners.remove(providerListener);
        for (ProviderMetadata provider : this.computeProviders) {
            providerListener.providerUninstalled(provider);
        }
    }

    public void registerBlobStoreListener(BlobStoreProviderListener providerListener) {
        this.blobStoreListeners.add(providerListener);
        for (ProviderMetadata provider : this.blobStoreProviders) {
            providerListener.providerInstalled(provider);
        }
    }

    public void unregisterBlobStoreListener(BlobStoreProviderListener providerListener) {
        this.blobStoreListeners.remove(providerListener);
        for (ProviderMetadata provider : this.blobStoreProviders) {
            providerListener.providerUninstalled(provider);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

