/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.core;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.karaf.core.NodeListener;
import org.jclouds.scriptbuilder.domain.Statement;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeServiceEventProxy
implements ComputeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputeServiceEventProxy.class);
    private BundleContext bundleContext;
    private ComputeService computeService;
    private ServiceTracker listenerTracker;

    public ComputeServiceEventProxy(BundleContext bundleContext, ComputeService computeService) {
        this.bundleContext = bundleContext;
        this.computeService = computeService;
        this.listenerTracker = new ServiceTracker(bundleContext, NodeListener.class.getName(), null);
        this.listenerTracker.open();
    }

    private List<? extends NodeListener> getNodeListeners() {
        LinkedList<NodeListener> listeners = new LinkedList<NodeListener>();
        try {
            listeners.addAll(Arrays.asList((NodeListener[])this.listenerTracker.getServices()));
        }
        catch (Exception ex) {
            LOGGER.warn("Could not lookup node listeners. Listeners will not receive the last event.");
        }
        return listeners;
    }

    public ComputeServiceContext getContext() {
        return this.computeService.getContext();
    }

    public TemplateBuilder templateBuilder() {
        return this.computeService.templateBuilder();
    }

    public TemplateOptions templateOptions() {
        return this.computeService.templateOptions();
    }

    public Set<? extends Hardware> listHardwareProfiles() {
        return this.computeService.listHardwareProfiles();
    }

    public Set<? extends Image> listImages() {
        return this.computeService.listImages();
    }

    public Set<? extends ComputeMetadata> listNodes() {
        return this.computeService.listNodes();
    }

    public Set<? extends Location> listAssignableLocations() {
        return this.computeService.listAssignableLocations();
    }

    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
        Set metadata = this.computeService.createNodesInGroup(group, count, template);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                for (NodeMetadata node : metadata) {
                    nodeListener.nodeCreated(node);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", (Throwable)ex);
        }
        return metadata;
    }

    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, TemplateOptions templateOptions) throws RunNodesException {
        Set metadata = this.computeService.createNodesInGroup(group, count, templateOptions);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                for (NodeMetadata node : metadata) {
                    nodeListener.nodeCreated(node);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", (Throwable)ex);
        }
        return metadata;
    }

    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count) throws RunNodesException {
        Set metadata = this.computeService.createNodesInGroup(group, count);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                for (NodeMetadata node : metadata) {
                    nodeListener.nodeCreated(node);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", (Throwable)ex);
        }
        return metadata;
    }

    public void resumeNode(String id) {
        this.computeService.resumeNode(id);
    }

    public void resumeNodesMatching(Predicate<NodeMetadata> filter) {
        this.computeService.resumeNodesMatching(filter);
    }

    public void suspendNode(String id) {
        this.computeService.suspendNode(id);
    }

    public void suspendNodesMatching(Predicate<NodeMetadata> filter) {
        this.computeService.suspendNodesMatching(filter);
    }

    public void destroyNode(String id) {
        NodeMetadata node = null;
        try {
            node = this.computeService.getNodeMetadata(id);
        }
        catch (Exception ex) {
            LOGGER.error("Error while retrieving node metadata.", (Throwable)ex);
        }
        this.computeService.destroyNode(id);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                nodeListener.nodeDestroyed(node);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", (Throwable)ex);
        }
    }

    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
        Set metadata = this.computeService.destroyNodesMatching(filter);
        try {
            for (NodeListener nodeListener : this.getNodeListeners()) {
                for (NodeMetadata node : metadata) {
                    nodeListener.nodeCreated(node);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error while notifying node listeners.", (Throwable)ex);
        }
        return metadata;
    }

    public void rebootNode(String id) {
        this.computeService.rebootNode(id);
    }

    public void rebootNodesMatching(Predicate<NodeMetadata> filter) {
        this.computeService.rebootNodesMatching(filter);
    }

    public NodeMetadata getNodeMetadata(String id) {
        return this.computeService.getNodeMetadata(id);
    }

    public Set<? extends NodeMetadata> listNodesDetailsMatching(Predicate<ComputeMetadata> filter) {
        return this.computeService.listNodesDetailsMatching(filter);
    }

    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript) throws RunScriptOnNodesException {
        return this.computeService.runScriptOnNodesMatching(filter, runScript);
    }

    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript) throws RunScriptOnNodesException {
        return this.computeService.runScriptOnNodesMatching(filter, runScript);
    }

    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        return this.computeService.runScriptOnNodesMatching(filter, runScript, options);
    }

    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        return this.computeService.runScriptOnNodesMatching(filter, runScript, options);
    }

    public ExecResponse runScriptOnNode(String id, Statement runScript, RunScriptOptions options) {
        return this.computeService.runScriptOnNode(id, runScript, options);
    }

    @Beta
    public ListenableFuture<ExecResponse> submitScriptOnNode(String id, Statement runScript, RunScriptOptions options) {
        return this.computeService.submitScriptOnNode(id, runScript, options);
    }

    public ExecResponse runScriptOnNode(String id, Statement runScript) {
        return this.computeService.runScriptOnNode(id, runScript);
    }

    public ExecResponse runScriptOnNode(String id, String runScript, RunScriptOptions options) {
        return this.computeService.runScriptOnNode(id, runScript, options);
    }

    public ExecResponse runScriptOnNode(String id, String runScript) {
        return this.computeService.runScriptOnNode(id, runScript);
    }

    public Image getImage(String id) {
        return this.computeService.getImage(id);
    }

    public Optional<ImageExtension> getImageExtension() {
        return this.computeService.getImageExtension();
    }
}

